/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class StrFileFilter
extends FileFilter {
    private int filtertyp;
    public static final int filterAlleSpeicherdateien = 0;
    private static final int filterAlleBilddateien = 3;

    public StrFileFilter(int filtertyp) {
        this.filtertyp = filtertyp;
    }

    @Override
    public boolean accept(File f) {
        return f.isDirectory() || this.dateiAkzeptiert(f.getAbsolutePath());
    }

    @Override
    public String getDescription() {
        switch (this.filtertyp) {
            case 0: {
                return "XML Dateien und strk Dateien";
            }
            case 1: {
                return "strk Dateien";
            }
            case 2: {
                return "XML Dateien";
            }
            case 3: {
                return "Bilddateien";
            }
            case 4: {
                return "BMP Dateien";
            }
            case 5: {
                return "GIF Dateien";
            }
            case 6: {
                return "JPG Dateien";
            }
            case 7: {
                return "PNG Dateien";
            }
        }
        return "";
    }

    private String gibAktuelleErweiterung() {
        switch (this.filtertyp) {
            case 0: {
                return ".strk";
            }
            case 1: {
                return ".strk";
            }
            case 2: {
                return ".xml";
            }
            case 3: {
                return ".png";
            }
            case 4: {
                return ".bmp";
            }
            case 5: {
                return ".gif";
            }
            case 6: {
                return ".jpg";
            }
            case 7: {
                return ".png";
            }
        }
        return "";
    }

    public String erweiterungBeiBedarfAnhaengen(String pfad) {
        if (this.dateiAkzeptiert(pfad)) {
            return pfad;
        }
        return String.valueOf(pfad) + this.gibAktuelleErweiterung();
    }

    private boolean dateiAkzeptiert(String pfad) {
        pfad = pfad.toLowerCase();
        switch (this.filtertyp) {
            case 0: {
                return pfad.endsWith(".xml") || pfad.endsWith(".strk");
            }
            case 3: {
                return pfad.endsWith(".bmp") || pfad.endsWith(".gif") || pfad.endsWith(".jpg") || pfad.endsWith(".jpeg") || pfad.endsWith(".png");
            }
        }
        return pfad.endsWith(this.gibAktuelleErweiterung());
    }
}

