/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Controlling;
import control.GlobalSettings;
import control.Konstanten;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import other.XActionCommands;
import view.AuswahlPanel;
import view.StrTabbedPane;

public class GUI
extends JFrame
implements Konstanten {
    private static final long serialVersionUID = -3526840402506170333L;
    private AuswahlPanel auswahlPanel;
    private StrTabbedPane tabbedpane;
    private Controlling controlling;
    private final JMenuBar menubar;

    public GUI(Controlling controlling) {
        super("Struktogrammeditor (Miniupdate) 1.7.2");
        this.setDefaultCloseOperation(0);
        int frameWidth = 1016;
        int frameHeight = 522;
        this.setSize(frameWidth, frameHeight);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - this.getSize().width) / 2;
        int y = (d.height - this.getSize().height) / 2;
        this.setLocation(x, y);
        this.controlling = controlling;
        this.setLayout(new BorderLayout());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/logostr.png")).getImage());
        this.tabbedpane = new StrTabbedPane(controlling);
        this.auswahlPanel = new AuswahlPanel(controlling);
        JSplitPane splitpane = new JSplitPane(1, new JScrollPane(this.auswahlPanel), this.tabbedpane);
        splitpane.setOneTouchExpandable(true);
        this.add((Component)splitpane, "Center");
        this.menubar = new JMenuBar();
        JMenu menu = this.createMenu("Datei", 68);
        menu.add(this.createMenuItem("Neu", XActionCommands.neu, 78, 78));
        menu.add(this.createMenuItem("\u00d6ffnen...", XActionCommands.oeffnen, 70, 79));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Speichern", XActionCommands.speichern, 83, 83));
        menu.add(this.createMenuItem("Speichern unter...", XActionCommands.speicherUnter, 85));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Als Bild speichern", XActionCommands.bildSpeichern, 65));
        menu.add(this.createMenuItem("Bild in Zwischenablage kopieren", XActionCommands.bildInZwischenAblage, 90, 75));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Quellcode erzeugen", XActionCommands.quellcodeErzeugen, 81));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Struktogramm Schlie\u00dfen", XActionCommands.struktogrammSchliessen, 75));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Programm beenden", XActionCommands.programmBeenden, 80));
        this.menubar.add(menu);
        menu = this.createMenu("Bearbeiten", 66);
        menu.add(this.createMenuItem("R\u00fcckg\u00e4ngig", XActionCommands.rueckgaengig, 82, 90));
        menu.add(this.createMenuItem("Widerrufen", XActionCommands.widerrufen, 87, 89));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Struktogrammname hinzuf\u00fcgen", XActionCommands.struktogrammbeschreibungHinzufuegen, 83));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Ganzes Struktogramm kopieren", XActionCommands.ganzesStruktogrammKopieren, 71));
        menu.add(this.createMenuItem("Element unter der Maus kopieren", XActionCommands.elementUnterDerMausKopieren, 75, 67));
        menu.add(this.createMenuItem("Kopiertes Element an Mausposition einf\u00fcgen", XActionCommands.elementEinfuegen, 69, 86));
        this.menubar.add(menu);
        menu = this.createMenu("Einstellungen", 69);
        menu.add(this.createMenuItem("Jeweils letztes Element bei Bedarf strecken", XActionCommands.letztesElementStrecken, 74, GlobalSettings.gibLetzteElementeStrecken()));
        menu.add(new JSeparator());
        JMenu menu2 = this.createMenu("Beschriftungsstil", 66);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem radioMenuitem = new JRadioButtonMenuItem("Java-\u00e4hnlich");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.beschriftungsStilJava.toString());
        radioMenuitem.setSelected(GlobalSettings.getBeschriftungsStilAktuell() == 0);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        radioMenuitem = new JRadioButtonMenuItem("Allgemein");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.beschriftungsStilFormal.toString());
        radioMenuitem.setSelected(GlobalSettings.getBeschriftungsStilAktuell() == 1);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        radioMenuitem = new JRadioButtonMenuItem("Element Shortcuts");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.beschriftungsStilKeineBeschriftungen.toString());
        radioMenuitem.setSelected(GlobalSettings.getBeschriftungsStilAktuell() == 2);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        menu.add(menu2);
        menu2 = this.createMenu("Look and Feel", 76);
        group = new ButtonGroup();
        radioMenuitem = new JRadioButtonMenuItem("Betriebssystem Standard");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.lookAndFeelOSStandard.toString());
        radioMenuitem.setSelected(GlobalSettings.getLookAndFeelAktuell() == 0);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        radioMenuitem = new JRadioButtonMenuItem("Java Swing Standard");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.lookAndFeelSwingStandard.toString());
        radioMenuitem.setSelected(GlobalSettings.getLookAndFeelAktuell() == 1);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        radioMenuitem = new JRadioButtonMenuItem("Nimbus");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.lookAndFeelNimbus.toString());
        radioMenuitem.setSelected(GlobalSettings.getLookAndFeelAktuell() == 2);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        radioMenuitem = new JRadioButtonMenuItem("Motif");
        radioMenuitem.addActionListener(controlling);
        radioMenuitem.setActionCommand(XActionCommands.lookAndFeelMotif.toString());
        radioMenuitem.setSelected(GlobalSettings.getLookAndFeelAktuell() == 3);
        group.add(radioMenuitem);
        menu2.add(radioMenuitem);
        menu.add(menu2);
        menu.add(this.createMenuItem("Startbeschriftungen \u00e4ndern...", XActionCommands.startbeschriftungAendern, 83));
        menu.add(this.createMenuItem("Schriftart \u00e4ndern...", XActionCommands.schriftartAendern, 70));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Gr\u00f6\u00dfe von Elementen mit Mausrad \u00e4ndern", XActionCommands.groesseAendernMitMausrad, 71, GlobalSettings.isBeiMausradGroesseAendern()));
        menu.add(this.createMenuItem("Zoomeinstellungen...", XActionCommands.zoomeinstellungen, 90));
        menu.add(this.createMenuItem("Alle Vergr\u00f6\u00dferungen r\u00fcckg\u00e4ngig machen", XActionCommands.vergroesserungenRuckgaengigMachen, 65));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Shortcuts zum Elementeinf\u00fcgen benutzen", XActionCommands.elementShortcutsVerwenden, 67, GlobalSettings.isElementShortcutsVerwenden()));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Kantengl\u00e4ttung verwenden", XActionCommands.kantenglaettungVerwenden, 75, GlobalSettings.isKantenglaettungVerwenden()));
        this.menubar.add(menu);
        menu = this.createMenu("Hilfe", 72);
        menu.add(this.createMenuItem("Homepage", XActionCommands.homepage, 77));
        menu.add(this.createMenuItem("Changelog", XActionCommands.changelog, 67));
        menu.add(this.createMenuItem("Kontakt, Feedback, Verbesserungsvorschl\u00e4ge, Fehler melden", XActionCommands.kontaktformular, 75));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Hilfedatei", XActionCommands.hilfe, 76));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("Info", XActionCommands.info, 73));
        this.menubar.add(menu);
        this.setJMenuBar(this.menubar);
        this.addWindowListener(controlling);
        this.setResizable(true);
        this.setVisible(true);
    }

    private JMenu createMenu(String name, int auswahlBuchstabe) {
        JMenu neuMenu = new JMenu(name);
        neuMenu.setMnemonic(auswahlBuchstabe);
        return neuMenu;
    }

    private JMenuItem createMenuItem(String name, XActionCommands actionCommand, int auswahlBuchstabe) {
        return this.createMenuItem(name, actionCommand, auswahlBuchstabe, -1, -1);
    }

    private JMenuItem createMenuItem(String name, XActionCommands actionCommand, int auswahlBuchstabe, int shortcutBuchstabe) {
        return this.createMenuItem(name, actionCommand, auswahlBuchstabe, shortcutBuchstabe, GlobalSettings.strgOderApfelMask, false, false);
    }

    private JMenuItem createMenuItem(String name, XActionCommands actionCommand, int auswahlBuchstabe, int shortcutBuchstabe, int shortcutMask) {
        return this.createMenuItem(name, actionCommand, auswahlBuchstabe, shortcutBuchstabe, shortcutMask, false, false);
    }

    private JMenuItem createMenuItem(String name, XActionCommands actionCommand, int auswahlBuchstabe, boolean isChecked) {
        return this.createMenuItem(name, actionCommand, auswahlBuchstabe, -1, -1, true, isChecked);
    }

    private JMenuItem createMenuItem(String name, XActionCommands actionCommand, int auswahlBuchstabe, int shortcutBuchstabe, int shortcutMask, boolean isCheckBox, boolean isChecked) {
        JMenuItem menuitem;
        if (isCheckBox) {
            menuitem = new JCheckBoxMenuItem(name);
            menuitem.setSelected(isChecked);
        } else {
            menuitem = new JMenuItem(name);
        }
        menuitem.setActionCommand(actionCommand.toString());
        if (auswahlBuchstabe > -1) {
            menuitem.setMnemonic(auswahlBuchstabe);
        }
        if (shortcutBuchstabe > -1) {
            menuitem.setAccelerator(KeyStroke.getKeyStroke(shortcutBuchstabe, shortcutMask));
        }
        menuitem.addActionListener(this.controlling);
        return menuitem;
    }

    public StrTabbedPane gibTabbedpane() {
        return this.tabbedpane;
    }

    public AuswahlPanel gibAuswahlPanel() {
        return this.auswahlPanel;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }
}

