/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.GlobalSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import view.GUI;

public class EinstellungsDialog
extends JDialog {
    private static final long serialVersionUID = -6402017961524470279L;
    public static final int anzahlStruktogrammElemente = 10;
    private JLabel[] labels = new JLabel[10];
    private JTextField[] textfields = new JTextField[10];
    private JButton buttonOK = new JButton();
    private JButton buttonAbbrechen = new JButton();
    private JButton buttonStandardWerte = new JButton();
    private final String[] beschreibungen = GlobalSettings.getCurrentElementBeschriftungsstil();
    public static final String[] standardWerte = new String[]{"Anweisung", "Verzweigung", "Fallauswahl", "0 < i < anzahl", "While Schleife", "Do-While Schleife", "Endlosschleife", "Aussprung", "Aufruf", "\u00f8"};

    public EinstellungsDialog(GUI gui, boolean modal) {
        super(gui, "Einstellungsdialog", modal);
        this.setDefaultCloseOperation(2);
        this.setSize(300, 440);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Beschriftungen von neu eingef\u00fcgten Elementen:"), "North");
        JPanel panel = new JPanel(new GridLayout(10, 2, 4, 4));
        int i = 0;
        while (i < 10) {
            this.labels[i] = new JLabel();
            this.labels[i].setBounds(10, 40 + 30 * i, 100, 20);
            this.labels[i].setText(this.beschreibungen[i]);
            panel.add(this.labels[i]);
            this.textfields[i] = new JTextField();
            this.textfields[i].setBounds(120, 40 + 30 * i, 150, 20);
            this.textfields[i].setText(GlobalSettings.gibElementBeschriftung(i));
            panel.add(this.textfields[i]);
            ++i;
        }
        this.add((Component)panel, "Center");
        panel = new JPanel(new FlowLayout(0));
        this.buttonOK.setBounds(10, 340, 91, 25);
        this.buttonOK.setText("OK");
        this.buttonOK.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EinstellungsDialog.this.buttonOK_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonOK);
        this.buttonAbbrechen.setBounds(115, 340, 91, 25);
        this.buttonAbbrechen.setText("Abbrechen");
        this.buttonAbbrechen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EinstellungsDialog.this.buttonAbbrechen_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonAbbrechen);
        this.buttonStandardWerte.setBounds(10, 380, 115, 25);
        this.buttonStandardWerte.setText("Standardwerte");
        this.buttonStandardWerte.setMargin(new Insets(2, 2, 2, 2));
        this.buttonStandardWerte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EinstellungsDialog.this.buttonStandardWerte_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonStandardWerte);
        this.add((Component)panel, "South");
        this.setVisible(true);
    }

    public void buttonOK_ActionPerformed(ActionEvent evt) {
        String[] neueWerte = new String[10];
        int i = 0;
        while (i < 10) {
            neueWerte[i] = this.textfields[i].getText();
            ++i;
        }
        GlobalSettings.setzeElementBeschriftungen(neueWerte);
        GlobalSettings.saveSettings();
        this.setVisible(false);
    }

    public void buttonAbbrechen_ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void buttonStandardWerte_ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < 10) {
            this.textfields[i].setText(standardWerte[i]);
            ++i;
        }
    }
}

