/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Controlling;
import control.GlobalSettings;
import control.Struktogramm;
import de.whiledo.updater.WhiledoUpdater;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Document;
import view.AuswahlPanelElement;

public class AuswahlPanel
extends JPanel
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = 3619714917985247680L;
    private AuswahlPanelElement[] panelElemente = new AuswahlPanelElement[9];
    private DragSource dragSource;
    private JLabel muelleimer;
    private JLabel kopierFeld;
    private boolean muelleimerIstAuf;
    private boolean kopierFeldIstAuf;
    private Controlling controlling;
    private Document kopiertesStrElement;

    public AuswahlPanel(Controlling controlling) {
        this.controlling = controlling;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 1;
        c.ipady = 1;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(0, 0, 4, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        int i = 0;
        while (i < this.panelElemente.length) {
            this.panelElemente[i] = new AuswahlPanelElement(i);
            this.add((Component)this.panelElemente[i], c);
            ++c.gridy;
            ++i;
        }
        this.muelleimer = new JLabel();
        this.muelleimerIstAuf = true;
        this.muelleimerAuf(!this.muelleimerIstAuf);
        this.muelleimer.setFont(new Font("monospaced", 0, 15));
        this.muelleimer.setText("Wegschmei\u00dfen");
        this.add((Component)this.muelleimer, c);
        ++c.gridy;
        c.weighty = 1000.0;
        this.kopiertesStrElement = null;
        this.kopierFeld = new JLabel();
        this.kopierFeldIstAuf = true;
        this.kopierFeldAuf(!this.kopierFeldIstAuf);
        this.kopierFeld.setFont(new Font("monospaced", 0, 15));
        this.kopierFeld.setText("Kopie");
        this.add((Component)this.kopierFeld, c);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this, true, null);
    }

    public void aktualisiereBeschriftungen() {
        int i = 0;
        while (i < this.panelElemente.length) {
            this.panelElemente[i].setText(GlobalSettings.getCurrentElementBeschriftungsstil()[i]);
            ++i;
        }
    }

    public void setzeKopiertesStrElement(Document doc) {
        this.kopiertesStrElement = doc;
    }

    public Document gibKopiertesStrElement() {
        return this.kopiertesStrElement;
    }

    private void muelleimerAuf(boolean oeffnen) {
        if (this.muelleimerIstAuf != oeffnen) {
            String bildname;
            if (oeffnen) {
                bildname = "muelleimer2.png";
                this.muelleimerIstAuf = true;
            } else {
                bildname = "muelleimer1.png";
                this.muelleimerIstAuf = false;
            }
            this.muelleimer.setIcon(WhiledoUpdater.ladeImageIconAusResource("/icons/" + bildname, this));
        }
    }

    private void kopierFeldAuf(boolean oeffnen) {
        if (this.kopierFeldIstAuf != oeffnen) {
            String bildname;
            if (oeffnen) {
                bildname = "kopiebox2.png";
                this.kopierFeldIstAuf = true;
            } else {
                bildname = "kopiebox1.png";
                this.kopierFeldIstAuf = false;
            }
            this.kopierFeld.setIcon(WhiledoUpdater.ladeImageIconAusResource("/icons/" + bildname, this));
        }
    }

    public void kopiereGanzesStruktogramm() {
        this.setzeKopiertesStrElement(this.controlling.gibAktuellesStruktogramm().xmlErstellen());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        Point mausPos = this.bildschirmKoordZuLokalenKoord(evt.getDragOrigin());
        Component element = this.getComponentAt(mausPos);
        if (element instanceof AuswahlPanelElement) {
            int typ = ((AuswahlPanelElement)element).gibTyp();
            StringSelection t = new StringSelection("n" + typ);
            this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
        } else if (element == this.kopierFeld && this.kopiertesStrElement != null) {
            StringSelection t = new StringSelection("k");
            this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            event.acceptDrop(event.getSourceActions());
            Transferable tr = event.getTransferable();
            String dragTyp = (String)tr.getTransferData(tr.getTransferDataFlavors()[0]);
            Component dropUeberComponent = this.getComponentAt(this.bildschirmKoordZuLokalenKoord(event.getLocation()));
            Struktogramm str = this.controlling.gibAktuellesStruktogramm();
            if (dragTyp.charAt(0) == 'z') {
                if (dropUeberComponent == this.muelleimer) {
                    str.elementAusZwischenlagerGanzEntfernen();
                    str.zeichenbereichAktualisieren();
                    str.zeichne();
                    str.rueckgaengigPunktSetzen();
                } else if (dropUeberComponent == this.kopierFeld) {
                    this.setzeKopiertesStrElement(str.xmlErstellen(str.gibZwischenlagerElement()));
                }
            }
            this.muelleimerAuf(false);
            this.kopierFeldAuf(false);
            event.dropComplete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
        this.muelleimerAuf(false);
        this.kopierFeldAuf(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        Component tmp = this.getComponentAt(this.bildschirmKoordZuLokalenKoord(evt.getLocation()));
        this.muelleimerAuf(tmp == this.muelleimer);
        this.kopierFeldAuf(tmp == this.kopierFeld);
    }

    public Point bildschirmKoordZuLokalenKoord(Point bildschirmKoord) {
        return new Point(bildschirmKoord.x - this.getX(), bildschirmKoord.y - this.getY());
    }
}

