/*
 * Decompiled with CFR 0.152.
 */
package other;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class JNumberField
extends JTextField {
    private static final long serialVersionUID = -3137694650317084473L;

    public JNumberField() {
        this.enableEvents(8L);
    }

    public double getDouble() {
        Double d = new Double(this.getText());
        return d;
    }

    public float getFloat() {
        Double d = new Double(this.getText());
        return d.floatValue();
    }

    public int getInt() {
        Double d = new Double(this.getText());
        return d.intValue();
    }

    public long getLong() {
        Double d = new Double(this.getText());
        return d.longValue();
    }

    public boolean isNumeric() {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", this.getText());
    }

    public void setDouble(double d) {
        this.setText(String.valueOf(d));
    }

    public void setDouble(double d, int N) {
        this.setText(String.format(Locale.ENGLISH, "%." + N + "f", d));
    }

    public void setFloat(float f) {
        this.setText(String.valueOf(f));
    }

    public void setFloat(float f, int N) {
        this.setText(String.format(Locale.ENGLISH, "%." + N + "f", Float.valueOf(f)));
    }

    public void setInt(int i) {
        this.setText(String.valueOf(i));
    }

    public void setLong(long l) {
        this.setText(String.valueOf(l));
    }

    public void clear() {
        this.setText("");
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (this.isNumeric() || this.getText().equals("-") || this.getText().equals("") || this.getText().equals(".")) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(Color.red);
        }
    }
}

