/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Struktogramm;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import struktogrammelemente.Fallauswahl;
import struktogrammelemente.Schleife;
import struktogrammelemente.StruktogrammElement;
import struktogrammelemente.StruktogrammElementListe;

public class XMLLeser {
    private Struktogramm struktogramm;

    public void ladeXLM(String pfad, Struktogramm struktogramm) {
        this.ladeXML(pfad, null, struktogramm);
    }

    public void ladeXLM(Document document, Struktogramm struktogramm) {
        this.ladeXML(null, document, struktogramm);
    }

    private void erstelleElementeRek(Element elem, StruktogrammElement tmp) {
        List alleTextzeilen = elem.getChildren("text");
        String[] textzeilen = new String[alleTextzeilen.size()];
        int i = 0;
        while (i < alleTextzeilen.size()) {
            textzeilen[i] = XMLLeser.decodeS(((Element)alleTextzeilen.get(i)).getText());
            ++i;
        }
        tmp.setzeText(textzeilen);
        if (tmp instanceof Schleife) {
            this.listenelementeErstellen(elem.getChild("schleifeninhalt"), ((Schleife)tmp).gibListe());
        } else if (tmp instanceof Fallauswahl) {
            List alleFaelle = elem.getChildren("fall");
            Fallauswahl fallauswahl = (Fallauswahl)tmp;
            fallauswahl.erstelleNeueListen(alleFaelle.size());
            int i2 = 0;
            while (i2 < alleFaelle.size()) {
                fallauswahl.gibListe(i2).setzeBeschreibung(XMLLeser.decodeS(((Element)alleFaelle.get(i2)).getAttributeValue("fallname")));
                this.listenelementeErstellen((Element)alleFaelle.get(i2), fallauswahl.gibListe(i2));
                ++i2;
            }
        }
    }

    private StruktogrammElementListe wurzelStruktogrammElementErstellen(Element elem) {
        StruktogrammElementListe liste = new StruktogrammElementListe(null);
        this.listenelementeErstellen(elem, liste);
        return liste;
    }

    private void listenelementeErstellen(Element elem, StruktogrammElementListe liste) {
        List alleUnterelemente = elem.getChildren("strelem");
        int i = 0;
        while (i < alleUnterelemente.size()) {
            Element tmp = (Element)alleUnterelemente.get(i);
            int typ = Integer.parseInt(tmp.getAttributeValue("typ"));
            StruktogrammElement neues = this.struktogramm.neuesStruktogrammElement(typ);
            this.setAttribute(neues, tmp);
            liste.hinzufuegen(neues);
            this.erstelleElementeRek((Element)alleUnterelemente.get(i), neues);
            ++i;
        }
    }

    private void setAttribute(StruktogrammElement struktogrammelement, Element zugehoerigesKopfelement) {
        String s = zugehoerigesKopfelement.getAttributeValue("zx");
        if (s != null) {
            struktogrammelement.setXVergroesserung(Integer.parseInt(s));
        }
        if ((s = zugehoerigesKopfelement.getAttributeValue("zy")) != null) {
            struktogrammelement.setYVergroesserung(Integer.parseInt(s));
        }
        if ((s = zugehoerigesKopfelement.getAttributeValue("textcolor")) != null) {
            struktogrammelement.setFarbeSchrift(Color.decode(s));
        }
        if ((s = zugehoerigesKopfelement.getAttributeValue("bgcolor")) != null) {
            struktogrammelement.setFarbeHintergrund(Color.decode(s));
        }
    }

    private void ladeXML(String pfad, Document document, Struktogramm struktogramm) {
        Document doc = null;
        try {
            if (document != null) {
                doc = document;
            } else {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(new File(pfad));
            }
            Element element = doc.getRootElement();
            this.struktogramm = struktogramm;
            String fontFamily = element.getAttributeValue("fontfamily");
            String fontSize = element.getAttributeValue("fontsize");
            String fontStyle = element.getAttributeValue("fontstyle");
            String struktogrammBeschreibung = element.getAttributeValue("caption");
            if (fontFamily != null && fontSize != null && fontStyle != null) {
                struktogramm.setFontStr(new Font(XMLLeser.decodeS(fontFamily), Integer.parseInt(fontStyle), Integer.parseInt(fontSize)));
            }
            if (struktogrammBeschreibung != null) {
                struktogramm.setStruktogrammBeschreibung(XMLLeser.decodeS(struktogrammBeschreibung));
            }
            struktogramm.gibListe().alleEntfernen();
            this.listenelementeErstellen(element, struktogramm.gibListe());
            if (struktogramm.gibGraphics() != null) {
                struktogramm.zeichenbereichAktualisieren();
                struktogramm.zeichne();
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public StruktogrammElementListe erstelleStruktogrammElementListe(Document document, Struktogramm struktogramm) {
        if (document != null) {
            this.struktogramm = struktogramm;
            return this.wurzelStruktogrammElementErstellen(document.getRootElement());
        }
        return null;
    }

    public static String encodeS(String s) {
        String ausgabe = "";
        if (s.equals("")) {
            ausgabe = "-1;";
        } else {
            int i = 0;
            while (i < s.length()) {
                ausgabe = String.valueOf(ausgabe) + s.charAt(i) + ";";
                ++i;
            }
        }
        return ausgabe;
    }

    private static String decodeS(String codiert) {
        String[] textzeileAlsZahlen = codiert.split(";");
        String s = "";
        int i = 0;
        while (i < textzeileAlsZahlen.length) {
            int zeichenNummer = Integer.parseInt(textzeileAlsZahlen[i]);
            s = zeichenNummer == -1 ? "" : String.valueOf(s) + (char)zeichenNummer;
            ++i;
        }
        return s;
    }
}

