/*
 * Decompiled with CFR 0.152.
 */
package control;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import control.GlobalSettings;
import control.Konstanten;
import control.MacHandler;
import control.Struktogramm;
import de.whiledo.updater.WhiledoUpdater;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import other.XActionCommands;
import struktogrammelemente.StruktogrammElement;
import view.CodeErzeuger;
import view.EinstellungsDialog;
import view.FontChooser;
import view.GUI;
import view.ZoomEinstellungen;

public class Controlling
implements Konstanten,
ActionListener,
WindowListener,
KeyListener {
    private GUI gui;

    public Controlling(String[] params) {
        this.handleOSSettingsAndLookAndFeel();
        this.gui = new GUI(this);
        this.neuesStruktogramm();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (new File(params[i]).exists()) {
                    this.openStruktogramm(params[i]);
                }
                ++i;
            }
        }
    }

    public void handleOSSettingsAndLookAndFeel() {
        try {
            Object lookAndFeel = null;
            switch (GlobalSettings.getLookAndFeelAktuell()) {
                case 0: {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (ClassNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (InstantiationException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (UnsupportedLookAndFeelException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    lookAndFeel = new NimbusLookAndFeel();
                    break;
                }
                case 3: {
                    lookAndFeel = new MotifLookAndFeel();
                }
            }
            if (lookAndFeel != null) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)lookAndFeel);
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
            }
            if (Controlling.getOS() == Betriebssysteme.Mac) {
                new MacHandler(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Betriebssysteme getOS() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.startsWith("windows")) {
            return Betriebssysteme.Windows;
        }
        if (s.startsWith("mac")) {
            return Betriebssysteme.Mac;
        }
        if (s.startsWith("linux")) {
            return Betriebssysteme.Linux;
        }
        return Betriebssysteme.Windows;
    }

    public Struktogramm gibAktuellesStruktogramm() {
        return this.gui.gibTabbedpane().gibAktuellesStruktogramm();
    }

    public Struktogramm neuesStruktogramm() {
        Struktogramm str = this.gui.gibTabbedpane().struktogrammHinzufuegen();
        str.graphicsInitialisieren();
        str.zeichenbereichAktualisieren();
        str.zeichne();
        return str;
    }

    public void speichern(boolean neuenSpeicherpfadAuswaehlenLassen) {
        Struktogramm str = this.gibAktuellesStruktogramm();
        if (str != null) {
            GlobalSettings.setzeSpeicherpfad(str.speichern(neuenSpeicherpfadAuswaehlenLassen, GlobalSettings.getZuletztGenutzterSpeicherpfad()));
            GlobalSettings.saveSettings();
            this.titelleisteAktualisieren();
        }
    }

    public void laden() {
        String pfad = Struktogramm.oeffnenDialog(GlobalSettings.getZuletztGenutzterSpeicherpfad(), this.gui);
        if (!pfad.equals("")) {
            this.openStruktogramm(pfad);
        }
    }

    private void openStruktogramm(String pfad) {
        Struktogramm str = this.neuesStruktogramm();
        str.graphicsInitialisieren();
        str.laden(pfad);
        GlobalSettings.setzeSpeicherpfad(pfad);
        GlobalSettings.saveSettings();
        this.titelleisteAktualisieren();
    }

    public void bildSpeichern() {
        Struktogramm str = this.gibAktuellesStruktogramm();
        if (str != null) {
            GlobalSettings.setzeBildSpeicherpfad(str.alsBilddateiSpeichern(GlobalSettings.getZuletztGenutzterPfadFuerBild()));
            GlobalSettings.saveSettings();
        }
    }

    public void titelleisteAktualisieren() {
        String pfad = "";
        Struktogramm str = this.gibAktuellesStruktogramm();
        if (str != null && !(pfad = str.gibAktuellenSpeicherpfad()).equals("")) {
            pfad = " [" + pfad + "]";
        }
        this.gui.setTitle("Struktogrammeditor (Miniupdate) 1.7.2" + pfad);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (XActionCommands.valueOf(e.getActionCommand())) {
            case neu: {
                this.neuesStruktogramm();
                break;
            }
            case oeffnen: {
                this.laden();
                break;
            }
            case speichern: {
                this.speichern(false);
                break;
            }
            case speicherUnter: {
                this.speichern(true);
                break;
            }
            case bildSpeichern: {
                this.bildSpeichern();
                break;
            }
            case bildInZwischenAblage: {
                Controlling.copyImagetoClipBoard(this.gibAktuellesStruktogramm().generateImage(false));
                break;
            }
            case quellcodeErzeugen: {
                new CodeErzeuger(this.gui, "Quellcode erzeugen", true, this.gibAktuellesStruktogramm());
                break;
            }
            case struktogrammSchliessen: {
                this.gui.gibTabbedpane().aktuellesStruktogrammschliessen();
                break;
            }
            case programmBeenden: {
                this.programmBeendenGeklickt();
                break;
            }
            case rueckgaengig: {
                this.gibAktuellesStruktogramm().schrittZurueck();
                break;
            }
            case widerrufen: {
                this.gibAktuellesStruktogramm().schrittNachVorne();
                break;
            }
            case ganzesStruktogrammKopieren: {
                this.gui.gibAuswahlPanel().kopiereGanzesStruktogramm();
                break;
            }
            case elementUnterDerMausKopieren: {
                this.kopiereElement();
                break;
            }
            case elementEinfuegen: {
                this.gibAktuellesStruktogramm().elementAusKopierFeldEinfuegenAnMausPos();
                break;
            }
            case letztesElementStrecken: {
                this.letzteElementeStreckenGeklickt(e.getSource());
                break;
            }
            case startbeschriftungAendern: {
                new EinstellungsDialog(this.gui, true);
                break;
            }
            case schriftartAendern: {
                new FontChooser(this, true);
                break;
            }
            case groesseAendernMitMausrad: {
                this.mitMausradElementeVergroessernGeklickt(e.getSource());
                break;
            }
            case zoomeinstellungen: {
                new ZoomEinstellungen(this.gui);
                break;
            }
            case vergroesserungenRuckgaengigMachen: {
                this.gibAktuellesStruktogramm().zoomsZuruecksetzen();
                break;
            }
            case elementShortcutsVerwenden: {
                this.elementEinfuegenShortcutsVerwendenGeklickt(e.getSource());
                break;
            }
            case kantenglaettungVerwenden: {
                this.kantenglaettungVerwendenGeklickt(e.getSource());
                break;
            }
            case homepage: {
                WhiledoUpdater.homepageAufrufen("http://whiledo.de/index.php?p=struktogrammeditor");
                break;
            }
            case changelog: {
                WhiledoUpdater.homepageAufrufen("http://strukt.whiledo.de/changelog.html");
                break;
            }
            case kontaktformular: {
                WhiledoUpdater.homepageAufrufen("http://strukt.whiledo.de/kontakt.php");
                break;
            }
            case hilfe: {
                WhiledoUpdater.homepageAufrufen("http://strukt.whiledo.de/hilfe.html");
                break;
            }
            case info: {
                this.showInfo();
                break;
            }
            case beschriftungsStilJava: {
                this.changeBeschriftungsStil(0);
                break;
            }
            case beschriftungsStilFormal: {
                this.changeBeschriftungsStil(1);
                break;
            }
            case beschriftungsStilKeineBeschriftungen: {
                this.changeBeschriftungsStil(2);
                break;
            }
            case lookAndFeelOSStandard: {
                this.changeLookAndFeel(0);
                break;
            }
            case lookAndFeelSwingStandard: {
                this.changeLookAndFeel(1);
                break;
            }
            case lookAndFeelNimbus: {
                this.changeLookAndFeel(2);
                break;
            }
            case lookAndFeelMotif: {
                this.changeLookAndFeel(3);
                break;
            }
            case struktogrammbeschreibungHinzufuegen: {
                this.addStruktogrammbeschriftung();
            }
        }
    }

    private void addStruktogrammbeschriftung() {
        Struktogramm str = this.gibAktuellesStruktogramm();
        String s = JOptionPane.showInputDialog("Beschriftung", (Object)str.getStruktogrammBeschreibung());
        if (s == null) {
            return;
        }
        str.setStruktogrammBeschreibung(s);
        str.rueckgaengigPunktSetzen();
        str.zeichenbereichAktualisieren();
        str.zeichne();
    }

    private void kopiereElement() {
        StruktogrammElement element = this.gibAktuellesStruktogramm().getElementUnterMaus();
        if (element != null) {
            this.getGUI().gibAuswahlPanel().setzeKopiertesStrElement(this.gibAktuellesStruktogramm().xmlErstellen(element));
        }
    }

    private void changeLookAndFeel(int beschriftungsStilIndex) {
        GlobalSettings.setLookAndFeelAktuell(beschriftungsStilIndex);
        GlobalSettings.saveSettings();
        JOptionPane.showMessageDialog(this.gui, "Die \u00ef\u00bf\u00bdnderungen werden beim Neustart des Programms wirksam.", "Look And Feel \u00ef\u00bf\u00bdnderung", 1);
    }

    private void changeBeschriftungsStil(int beschriftungsStilIndex) {
        GlobalSettings.setBeschriftungsStilAktuell(beschriftungsStilIndex);
        GlobalSettings.saveSettings();
        this.gui.gibAuswahlPanel().aktualisiereBeschriftungen();
    }

    public void showInfo() {
        String separator = System.getProperty("line.separator");
        String datumsfolge = "";
        String[] stringArray = GlobalSettings.updateDaten;
        int n = GlobalSettings.updateDaten.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            datumsfolge = String.valueOf(datumsfolge) + s + separator;
            ++n2;
        }
        JOptionPane.showMessageDialog(this.gui, "Struktogrammeditor 1.7.2" + separator + "Kevin Krummenauer - 2011-2012" + separator + "Informatik Projekt Stufe 13.2, AMG Beckum, Februar/M\u00ef\u00bf\u00bdrz 2011" + separator + separator + "Updates:" + separator + datumsfolge + separator + separator + "This product includes software developed by the JDOM Project (http://www.jdom.org/).", "Information - Struktogrammeditor 1.7.2", 1);
    }

    private void letzteElementeStreckenGeklickt(Object source) {
        GlobalSettings.setzeLetzteElementeStrecken(((JCheckBoxMenuItem)source).isSelected());
        GlobalSettings.saveSettings();
        this.gibAktuellesStruktogramm().zeichenbereichAktualisieren();
        this.gibAktuellesStruktogramm().zeichne();
    }

    private void mitMausradElementeVergroessernGeklickt(Object source) {
        boolean einOderAus = ((JCheckBoxMenuItem)source).isSelected();
        GlobalSettings.setBeiMausradGroesseAendern(einOderAus);
        GlobalSettings.saveSettings();
        this.gibAktuellesStruktogramm().mausradScrollEinOderAusschalten(einOderAus);
        this.gibAktuellesStruktogramm().zeichenbereichAktualisieren();
        this.gibAktuellesStruktogramm().zeichne();
    }

    private void elementEinfuegenShortcutsVerwendenGeklickt(Object source) {
        boolean einOderAus = ((JCheckBoxMenuItem)source).isSelected();
        GlobalSettings.setElementShortcutsVerwenden(einOderAus);
        GlobalSettings.saveSettings();
    }

    private void kantenglaettungVerwendenGeklickt(Object source) {
        GlobalSettings.setKantenglaettungVerwenden(((JCheckBoxMenuItem)source).isSelected());
        GlobalSettings.saveSettings();
        this.gibAktuellesStruktogramm().graphicsInitialisieren();
        this.gibAktuellesStruktogramm().zeichenbereichAktualisieren();
        this.gibAktuellesStruktogramm().zeichne();
    }

    public GUI getGUI() {
        return this.gui;
    }

    public boolean programmBeendenGeklickt() {
        if (this.gui.gibTabbedpane().einOderMehrereStruktogrammeNichtGespeichert()) {
            Object[] options = new Object[]{"Ja", "Nein"};
            if (JOptionPane.showOptionDialog(this.gui, "Ein oder mehrere Struktogramme wurden noch nicht gespeichert.\nWirklich Beenden ohne zu speichern?", "Noch nicht gespeichert", 0, 2, null, options, options[1]) == 0) {
                System.exit(0);
                return true;
            }
            return false;
        }
        System.exit(0);
        return true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.programmBeendenGeklickt();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.gui.gibTabbedpane() && e.getModifiers() != GlobalSettings.strgOderApfelMask) {
            switch (e.getKeyChar()) {
                case '+': {
                    this.gibAktuellesStruktogramm().zoomAktuellesElement(true);
                    break;
                }
                case '-': {
                    this.gibAktuellesStruktogramm().zoomAktuellesElement(false);
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.gui.gibTabbedpane() && e.getModifiers() != GlobalSettings.strgOderApfelMask) {
            switch (e.getKeyCode()) {
                case 65: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(0);
                    break;
                }
                case 73: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(1);
                    break;
                }
                case 83: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(2);
                    break;
                }
                case 70: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(3);
                    break;
                }
                case 87: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(4);
                    break;
                }
                case 68: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(5);
                    break;
                }
                case 69: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(6);
                    break;
                }
                case 66: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(7);
                    break;
                }
                case 77: {
                    if (!GlobalSettings.isElementShortcutsVerwenden()) break;
                    this.gibAktuellesStruktogramm().neuesElementAnAktuellerStelleEinfuegen(8);
                    break;
                }
                case 127: {
                    this.gibAktuellesStruktogramm().elementAnAktuellerStelleLoeschen();
                }
            }
        }
    }

    public static void copyImagetoClipBoard(final BufferedImage image) {
        Transferable transferable = new Transferable(){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor.equals(DataFlavor.imageFlavor) && image != null) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                DataFlavor[] flavors;
                DataFlavor[] dataFlavorArray = flavors = this.getTransferDataFlavors();
                int n = flavors.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor f = dataFlavorArray[n2];
                    if (flavor.equals(f)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        ClipboardOwner clipboardOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, clipboardOwner);
    }

    private static enum Betriebssysteme {
        Windows,
        Mac,
        Linux;

    }
}

