/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Struktogramm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import struktogrammelemente.Fallauswahl;
import struktogrammelemente.StruktogrammElement;
import struktogrammelemente.Verzweigung;

public class StruktogrammPopup
extends JPopupMenu
implements PopupMenuListener {
    private static final long serialVersionUID = -6394669590636692950L;
    private int typ;
    private StruktogrammElement element;
    private Struktogramm struktogramm;

    public StruktogrammPopup(StruktogrammElement element, Struktogramm struktogramm) {
        this.addPopupMenuListener(this);
        this.element = element;
        this.struktogramm = struktogramm;
        this.typ = Struktogramm.strElementZuTypnummer(element);
        StrPopupUntermenue untermenue = this.unterMenueEinfuegen("Zoom");
        untermenue.einfuegen("Gr\u00f6\u00dfer", 8, -1);
        untermenue.einfuegen("Kleiner", 9, -1);
        untermenue.add(new JSeparator());
        untermenue.einfuegen("Breiter", 10, -1);
        untermenue.einfuegen("Schmaler", 11, -1);
        untermenue.add(new JSeparator());
        untermenue.einfuegen("H\u00f6her", 12, -1);
        untermenue.einfuegen("Weniger hoch", 13, -1);
        this.add(new JSeparator());
        this.einfuegen("Text \u00e4ndern", 0);
        this.einfuegen("Kopieren", 7);
        this.einfuegen("L\u00f6schen...", 1);
        switch (this.typ) {
            case 1: {
                this.add(new JSeparator());
                this.einfuegen("Ja- und Neinseite vertauschen", 2);
                break;
            }
            case 2: {
                this.add(new JSeparator());
                this.einfuegen("Neuen Fall einf\u00fcgen", 3);
                String[] faelle = element.gibFaelle();
                int i = 0;
                while (i < faelle.length) {
                    untermenue = this.unterMenueEinfuegen("Fall: " + faelle[i]);
                    if (i > 0) {
                        untermenue.einfuegen("Fall \"" + faelle[i] + "\" nach links verschieben", 4, i);
                    }
                    if (i < faelle.length - 1) {
                        untermenue.einfuegen("Fall \"" + faelle[i] + "\" nach rechts verschieben", 5, i);
                        untermenue.einfuegen("Fall \"" + faelle[i] + "\" entfernen", 6, i);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void einfuegen(String text, int id) {
        this.add(new StrPopupItem(text, id));
    }

    private StrPopupUntermenue unterMenueEinfuegen(String text) {
        StrPopupUntermenue tmp = new StrPopupUntermenue(this.element, this.struktogramm, text);
        this.add(tmp);
        return tmp;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.struktogramm.setzePopupmenuSichtbar(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.struktogramm.setzePopupmenuSichtbar(false);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.struktogramm.setzePopupmenuSichtbar(false);
    }

    private class StrPopupItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private int id;
        private int fallnummer;

        public StrPopupItem(String text, int id) {
            this(text, id, -1);
        }

        public StrPopupItem(String text, int id, int fallnummer) {
            super(text);
            this.id = id;
            this.fallnummer = fallnummer;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean mussSpeicherpunktSetzen = true;
            switch (this.id) {
                case 0: {
                    StruktogrammPopup.this.struktogramm.elementBefuellen(StruktogrammPopup.this.element);
                    mussSpeicherpunktSetzen = false;
                    break;
                }
                case 1: {
                    StruktogrammPopup.this.struktogramm.elementLoeschen(StruktogrammPopup.this.element, true);
                    mussSpeicherpunktSetzen = false;
                    break;
                }
                case 2: {
                    ((Verzweigung)StruktogrammPopup.this.element).seitenVertauschen();
                    break;
                }
                case 3: {
                    ((Fallauswahl)StruktogrammPopup.this.element).erstelleNeueSpalte();
                    break;
                }
                case 4: {
                    ((Fallauswahl)StruktogrammPopup.this.element).spalteVerschieben(true, this.fallnummer);
                    break;
                }
                case 5: {
                    ((Fallauswahl)StruktogrammPopup.this.element).spalteVerschieben(false, this.fallnummer);
                    break;
                }
                case 6: {
                    String fallname = ((Fallauswahl)StruktogrammPopup.this.element).gibFaelle()[this.fallnummer];
                    if (JOptionPane.showConfirmDialog(null, "Den Fall \"" + fallname + "\" mit dessen Unterelementen l\u00f6schen?", "Fall entfernen", 0) == 0) {
                        ((Fallauswahl)StruktogrammPopup.this.element).entferneSpalte(this.fallnummer);
                        break;
                    }
                    mussSpeicherpunktSetzen = false;
                    break;
                }
                case 7: {
                    StruktogrammPopup.this.struktogramm.gibTabbedPane().gibGUI().gibAuswahlPanel().setzeKopiertesStrElement(StruktogrammPopup.this.struktogramm.xmlErstellen(StruktogrammPopup.this.element));
                    mussSpeicherpunktSetzen = false;
                    break;
                }
                case 8: {
                    StruktogrammPopup.this.struktogramm.zoom(1, 1, StruktogrammPopup.this.element);
                    break;
                }
                case 9: {
                    StruktogrammPopup.this.struktogramm.zoom(-1, -1, StruktogrammPopup.this.element);
                    break;
                }
                case 10: {
                    StruktogrammPopup.this.struktogramm.zoom(1, 0, StruktogrammPopup.this.element);
                    break;
                }
                case 11: {
                    StruktogrammPopup.this.struktogramm.zoom(-1, 0, StruktogrammPopup.this.element);
                    break;
                }
                case 12: {
                    StruktogrammPopup.this.struktogramm.zoom(0, 1, StruktogrammPopup.this.element);
                    break;
                }
                case 13: {
                    StruktogrammPopup.this.struktogramm.zoom(0, -1, StruktogrammPopup.this.element);
                }
            }
            StruktogrammPopup.this.struktogramm.zeichenbereichAktualisieren();
            StruktogrammPopup.this.struktogramm.zeichne();
            if (mussSpeicherpunktSetzen) {
                StruktogrammPopup.this.struktogramm.rueckgaengigPunktSetzen();
            }
        }
    }

    private class StrPopupUntermenue
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public StrPopupUntermenue(StruktogrammElement element, Struktogramm struktogramm, String text) {
            super(text);
        }

        private void einfuegen(String text, int id, int fallnummer) {
            this.add(new StrPopupItem(text, id, fallnummer));
        }
    }
}

