/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.Controlling;
import control.GlobalSettings;
import control.Struktogramm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FontChooser
extends JDialog {
    private static final long serialVersionUID = -7360108534182191037L;
    private String[] schriftarten;
    private JComboBox schriftartenChooser;
    private JComboBox styleChooser;
    private JComboBox sizeChooser;
    private JButton buttonOK = new JButton();
    private JButton buttonAbbrechen = new JButton();
    private JButton buttonZuruecksetzen = new JButton();
    private Controlling controlling;
    static final String[] styleNames = new String[]{"Normal", "Kursiv", "Fett", "Fett und Kursiv"};
    static final Integer[] styleValues = new Integer[]{new Integer(0), new Integer(2), new Integer(1), new Integer(3)};
    static final String[] sizeNames = new String[]{"8", "10", "12", "14", "15", "18", "20", "24", "28", "32", "40", "48", "56", "64", "72"};

    public FontChooser(Controlling controlling, boolean modal) {
        super(controlling.getGUI(), "Schriftart \u00e4ndern", modal);
        this.setDefaultCloseOperation(2);
        this.setSize(465, 120);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setLayout(new BorderLayout());
        this.controlling = controlling;
        this.schriftarten = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        JPanel panel = new JPanel(new FlowLayout(0));
        this.schriftartenChooser = new JComboBox<String>(this.schriftarten);
        this.schriftartenChooser.setBounds(10, 10, 250, 20);
        panel.add(this.schriftartenChooser);
        this.styleChooser = new JComboBox<String>(styleNames);
        this.styleChooser.setBounds(270, 10, 120, 20);
        panel.add(this.styleChooser);
        this.sizeChooser = new JComboBox<String>(sizeNames);
        this.sizeChooser.setBounds(400, 10, 50, 20);
        panel.add(this.sizeChooser);
        this.add((Component)panel, "North");
        this.fontAufChooser(controlling.gibAktuellesStruktogramm().getFontStr());
        panel = new JPanel(new FlowLayout(0));
        this.buttonOK.setBounds(10, 40, 91, 25);
        this.buttonOK.setText("OK");
        this.buttonOK.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.buttonOK_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonOK);
        this.buttonAbbrechen.setBounds(115, 40, 91, 25);
        this.buttonAbbrechen.setText("Abbrechen");
        this.buttonAbbrechen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.buttonAbbrechen_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonAbbrechen);
        this.buttonZuruecksetzen.setBounds(220, 40, 91, 25);
        this.buttonZuruecksetzen.setText("Zur\u00fccksetzen");
        this.buttonZuruecksetzen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonZuruecksetzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.buttonZuruecksetzen_ActionPerformed(evt);
            }
        });
        panel.add(this.buttonZuruecksetzen);
        this.add((Component)panel, "South");
        this.setVisible(true);
    }

    private void fontAufChooser(Font font) {
        int pos = 0;
        String schriftart = font.getFamily();
        int i = 0;
        while (i < this.schriftarten.length) {
            if (this.schriftarten[i].toLowerCase().equals(schriftart.toLowerCase())) {
                pos = i;
                break;
            }
            ++i;
        }
        this.schriftartenChooser.setSelectedIndex(pos);
        int a = font.getStyle();
        int i2 = 0;
        while (i2 < styleValues.length) {
            if (styleValues[i2] == a) {
                pos = i2;
                break;
            }
            ++i2;
        }
        this.styleChooser.setSelectedIndex(pos);
        a = font.getSize();
        i2 = 0;
        while (i2 < sizeNames.length) {
            if (sizeNames[i2].equals("" + a)) {
                pos = i2;
                break;
            }
            ++i2;
        }
        this.sizeChooser.setSelectedIndex(pos);
    }

    public void buttonOK_ActionPerformed(ActionEvent evt) {
        Struktogramm str = this.controlling.gibAktuellesStruktogramm();
        str.setFontStr(new Font(this.schriftartenChooser.getSelectedItem().toString(), (int)styleValues[this.styleChooser.getSelectedIndex()], Integer.parseInt(sizeNames[this.sizeChooser.getSelectedIndex()])));
        str.rueckgaengigPunktSetzen(true);
        str.graphicsInitialisieren();
        str.zeichenbereichAktualisieren();
        str.zeichne();
        this.setVisible(false);
    }

    public void buttonAbbrechen_ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void buttonZuruecksetzen_ActionPerformed(ActionEvent evt) {
        this.fontAufChooser(GlobalSettings.fontStandard);
    }
}

