/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import other.JListEasy;
import other.JTextAreaEasy;
import struktogrammelemente.Fallauswahl;
import struktogrammelemente.StruktogrammElement;
import struktogrammelemente.Verzweigung;
import view.ColorDialog;

public class EingabeDialog
extends JDialog {
    private static final long serialVersionUID = -7385908673937166978L;
    private JTextAreaEasy textarea;
    private JListEasy list;
    private String[] rueckgabeInhalt;
    private StruktogrammElement element;
    private boolean okWurdeGedrueckt = false;
    private Color schriftfarbeNeu;
    private Color hintergrundfarbeNeu;
    private final JButton buttonSchriftfarbe;
    private final JButton buttonHintergrundfarbe;

    public EingabeDialog(JFrame owner, String title, boolean modal, StruktogrammElement element) {
        super(owner, title, modal);
        JButton button;
        this.setDefaultCloseOperation(2);
        this.element = element;
        this.schriftfarbeNeu = element.getFarbeSchrift();
        this.hintergrundfarbeNeu = element.getFarbeHintergrund();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.ipadx = 1;
        c.ipady = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 4, 0);
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)new JLabel("Inhalt des Kopfteils:"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 100.0;
        c.weighty = 200.0;
        c.fill = 1;
        this.textarea = new JTextAreaEasy();
        this.add((Component)new JScrollPane(this.textarea), c);
        c.weighty = 1.0;
        c.fill = 2;
        String[] vorherigerInhalt = element.gibText();
        int i = 0;
        while (i < vorherigerInhalt.length) {
            this.textarea.hinzufuegen(vorherigerInhalt[i]);
            if (i != vorherigerInhalt.length - 1) {
                this.textarea.zeilenumbruch();
            }
            ++i;
        }
        this.rueckgabeInhalt = vorherigerInhalt;
        int anzahlListen = element.gibAnzahlListen();
        if (anzahlListen > 0) {
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 1.0;
            this.add((Component)new JLabel(element instanceof Verzweigung ? "Beschriftungen links und rechts:" : "Beschriftungen der F\u00e4lle:"), c);
            c.gridx = 0;
            c.gridy = 3;
            c.weightx = 100.0;
            c.weighty = 1.0;
            this.list = new JListEasy();
            this.add((Component)new JScrollPane(this.list), c);
            c.weighty = 1.0;
            c.gridwidth = 1;
            c.fill = 0;
            c.gridx = 2;
            c.gridy = 4;
            c.weightx = 100.0;
            button = new JButton("Fallbeschriftung \u00e4ndern");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EingabeDialog.this.buttonFallname_ActionPerformed(e);
                }
            });
            this.add((Component)button, c);
            String[] inhaltVorher = element.gibFaelle();
            int i2 = 0;
            while (i2 < anzahlListen) {
                this.list.fuegeHinzu(inhaltVorher[i2]);
                ++i2;
            }
        }
        c.gridwidth = 1;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        this.buttonSchriftfarbe = button = new JButton("Schriftfarbe");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EingabeDialog.this.buttonSchriftfarbeGeklickt();
            }
        });
        this.add((Component)button, c);
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 100.0;
        this.buttonHintergrundfarbe = button = new JButton("Hintergrundfarbe");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EingabeDialog.this.buttonHintergrundfarbeGeklickt();
            }
        });
        this.add((Component)button, c);
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 1.0;
        c.fill = 2;
        button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EingabeDialog.this.buttonOK_ActionPerformed(e);
            }
        });
        this.add((Component)button, c);
        c.fill = 0;
        c.anchor = 13;
        c.gridx = 2;
        c.gridy = 5;
        c.weightx = 100.0;
        button = new JButton("Abbrechen");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EingabeDialog.this.buttonAbbrechen_ActionPerformed(e);
            }
        });
        this.add((Component)button, c);
        this.aktualisiereButtonfarben();
        this.setSize(400, 500);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public void buttonOK_ActionPerformed(ActionEvent evt) {
        if (this.element instanceof Fallauswahl) {
            String[] fallBezeichnungen = new String[this.list.gibAnzahl()];
            int i = 0;
            while (i < fallBezeichnungen.length) {
                fallBezeichnungen[i] = this.list.gibInhalt(i);
                ++i;
            }
            this.element.setzeFaelle(fallBezeichnungen);
        }
        this.element.setFarbeSchrift(this.schriftfarbeNeu);
        this.element.setFarbeHintergrund(this.hintergrundfarbeNeu);
        this.rueckgabeInhalt = this.textarea.gibTextzeilenArray();
        this.okWurdeGedrueckt = true;
        this.setVisible(false);
    }

    private void buttonSchriftfarbeGeklickt() {
        this.schriftfarbeNeu = ColorDialog.showColorChooser(this, this.schriftfarbeNeu);
        this.aktualisiereButtonfarben();
    }

    private void buttonHintergrundfarbeGeklickt() {
        this.hintergrundfarbeNeu = ColorDialog.showColorChooser(this, this.hintergrundfarbeNeu);
        this.aktualisiereButtonfarben();
    }

    public void buttonAbbrechen_ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void buttonFallname_ActionPerformed(ActionEvent evt) {
        if (this.list.gibIndex() >= 0) {
            String fallname = JOptionPane.showInputDialog("Neuer Fallname", (Object)this.list.gibMarkiertenInhalt());
            if (fallname != null) {
                if (fallname.equals("")) {
                    fallname = " ";
                }
                this.list.setzeText(fallname, this.list.gibIndex());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Bitte eine Fallbeschreibung ausw\u00e4hlen", "Ausw\u00e4hlen", 0);
        }
    }

    public String[] gibTextArray() {
        return this.okWurdeGedrueckt ? this.rueckgabeInhalt : null;
    }

    public Color getSchriftfarbeNeu() {
        return this.schriftfarbeNeu;
    }

    public Color getHintergrundfarbeNeu() {
        return this.hintergrundfarbeNeu;
    }

    private void aktualisiereButtonfarben() {
        this.buttonSchriftfarbe.setForeground(this.schriftfarbeNeu);
        this.buttonHintergrundfarbe.setBackground(this.hintergrundfarbeNeu);
    }
}

