/*
 * Decompiled with CFR 0.152.
 */
package view;

import control.GlobalSettings;
import control.Struktogramm;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import other.JNumberField;
import other.JTextAreaEasy;

public class CodeErzeuger
extends JDialog {
    private static final long serialVersionUID = 6073577055724789562L;
    private ButtonGroup buttongroup = new ButtonGroup();
    private JRadioButton javaButton = new JRadioButton();
    private JRadioButton delphiButton = new JRadioButton();
    private JTextAreaEasy textarea;
    private JCheckBox checkboxKommentare = new JCheckBox();
    private JLabel jLabel1 = new JLabel();
    private JNumberField numberfieldEinrueckung = new JNumberField();
    private JLabel jLabel2 = new JLabel();
    private JNumberField numberfieldZeichenzahl = new JNumberField();
    private JButton buttonCodeErzeugen = new JButton();
    private JButton buttonSchliessen = new JButton();
    private Struktogramm str;
    public static final int typJava = 0;
    public static final int typDelphi = 1;

    public CodeErzeuger(JFrame owner, String title, boolean modal, Struktogramm str) {
        super(owner, title, modal);
        this.setDefaultCloseOperation(2);
        int frameWidth = 498;
        int frameHeight = 437;
        this.setSize(frameWidth, frameHeight);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - this.getSize().width) / 2;
        int y = (d.height - this.getSize().height) / 2;
        this.setLocation(x, y);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        this.javaButton.setBounds(16, 240, 113, 17);
        this.javaButton.setText("Java Code");
        cp.add(this.javaButton);
        this.delphiButton.setBounds(16, 264, 113, 17);
        this.delphiButton.setText("Pascal Code");
        cp.add(this.delphiButton);
        this.checkboxKommentare.setBounds(16, 216, 329, 17);
        this.checkboxKommentare.setText("Struktogramminhalt als Kommentare ausgeben");
        this.checkboxKommentare.setSelected(GlobalSettings.isCodeErzeugerAlsKommentar());
        cp.add(this.checkboxKommentare);
        this.jLabel1.setBounds(16, 296, 323, 16);
        this.jLabel1.setText("Erste Zeile soll wie viele Stellen weit einger\u00fcckt sein?");
        this.jLabel1.setFont(new Font("MS Sans Serif", 0, 13));
        cp.add(this.jLabel1);
        this.numberfieldEinrueckung.setBounds(344, 296, 49, 24);
        this.numberfieldEinrueckung.setText("" + GlobalSettings.getCodeErzeugerEinrueckungGesamt());
        cp.add(this.numberfieldEinrueckung);
        this.jLabel2.setBounds(16, 328, 244, 16);
        this.jLabel2.setText("Anzahl der Leerzeichen pro Einr\u00fcckung:");
        this.jLabel2.setFont(new Font("MS Sans Serif", 0, 13));
        cp.add(this.jLabel2);
        this.numberfieldZeichenzahl.setBounds(344, 328, 49, 24);
        this.numberfieldZeichenzahl.setText("" + GlobalSettings.getCodeErzeugerEinrueckungProStufe());
        cp.add(this.numberfieldZeichenzahl);
        this.buttonCodeErzeugen.setBounds(16, 368, 147, 25);
        this.buttonCodeErzeugen.setText("Code erzeugen");
        this.buttonCodeErzeugen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCodeErzeugen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeErzeuger.this.buttonCodeErzeugen_ActionPerformed(evt);
            }
        });
        cp.add(this.buttonCodeErzeugen);
        this.buttonSchliessen.setBounds(296, 368, 91, 25);
        this.buttonSchliessen.setText("Schlie\u00dfen");
        this.buttonSchliessen.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSchliessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeErzeuger.this.buttonSchliessen_ActionPerformed(evt);
            }
        });
        cp.add(this.buttonSchliessen);
        this.buttongroup.add(this.javaButton);
        this.buttongroup.add(this.delphiButton);
        if (GlobalSettings.getCodeErzeugerProgrammiersprache() == 0) {
            this.javaButton.setSelected(true);
        } else {
            this.delphiButton.setSelected(true);
        }
        this.checkboxKommentare.setSelected(GlobalSettings.isCodeErzeugerAlsKommentar());
        this.textarea = new JTextAreaEasy(8, 10, 480, 200);
        this.textarea.setzeFont(new Font("Monospaced", 0, 15));
        this.textarea.setzeContainer(cp);
        this.str = str;
        this.setResizable(false);
        this.setVisible(true);
    }

    public JRadioButton getSelectedRadioButton(ButtonGroup bg) {
        Enumeration<AbstractButton> e = bg.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            return (JRadioButton)b;
        }
        return null;
    }

    public void buttonCodeErzeugen_ActionPerformed(ActionEvent evt) {
        if (this.numberfieldEinrueckung.isNumeric() && this.numberfieldZeichenzahl.isNumeric()) {
            JRadioButton radioB = this.getSelectedRadioButton(this.buttongroup);
            int typ = 0;
            if (radioB == this.javaButton) {
                typ = 0;
            } else if (radioB == this.delphiButton) {
                typ = 1;
            }
            this.textarea.leeren();
            int einrueckung = this.numberfieldEinrueckung.getInt();
            int einrueckungProStufe = this.numberfieldZeichenzahl.getInt();
            boolean alsKommentar = this.checkboxKommentare.isSelected();
            this.str.gibListe().quellcodeAllerUnterelementeGenerieren(typ, einrueckung, einrueckungProStufe, alsKommentar, this.textarea);
            GlobalSettings.setCodeErzeugerEinrueckungGesamt(einrueckung);
            GlobalSettings.setCodeErzeugerEinrueckungProStufe(einrueckungProStufe);
            GlobalSettings.setCodeErzeugerProgrammiersprache(typ);
            GlobalSettings.setCodeErzeugerAlsKommentar(alsKommentar);
            GlobalSettings.saveSettings();
        } else {
            JOptionPane.showMessageDialog(null, "Bitte Ganzzahlen in die Textfelder eingeben", "Fehler", 0);
        }
    }

    public static String gibKommentarZeichen(boolean kommentarStart, int codeTyp) {
        switch (codeTyp) {
            case 0: {
                if (kommentarStart) {
                    return "/*";
                }
                return "*/";
            }
            case 1: {
                if (kommentarStart) {
                    return "{";
                }
                return "}";
            }
        }
        return "";
    }

    public static String gibBlockZeichen(boolean blockStart, int codeTyp) {
        switch (codeTyp) {
            case 0: {
                if (blockStart) {
                    return "{";
                }
                return "}";
            }
            case 1: {
                if (blockStart) {
                    return "begin";
                }
                return "end;";
            }
        }
        return "";
    }

    public static boolean mussBlockanfangEinruecken(int typ) {
        return typ == 1;
    }

    public void buttonSchliessen_ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

