/*
 * Decompiled with CFR 0.152.
 */
package struktogrammelemente;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.jdom.Element;
import other.JTextAreaEasy;
import struktogrammelemente.LeerElement;
import struktogrammelemente.StruktogrammElement;

public class StruktogrammElementListe
extends ArrayList<StruktogrammElement> {
    private static final long serialVersionUID = -122818269830027765L;
    private Rectangle bereich = new Rectangle();
    private Graphics2D g;
    private String beschreibung = "";

    public StruktogrammElementListe(Graphics2D g) {
        this.g = g;
        this.add(new LeerElement(g));
    }

    public void setzeBeschreibung(String beschr) {
        this.beschreibung = beschr;
    }

    public String gibBeschreibung() {
        return this.beschreibung;
    }

    public int gibAnzahlUnterelemente() {
        return this.size();
    }

    public void quellcodeAllerUnterelementeGenerieren(int typ, int anzahlEingerueckt, int anzahlEinzuruecken, boolean alsKommentar, JTextAreaEasy textarea) {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).quellcodeGenerieren(typ, anzahlEingerueckt, anzahlEinzuruecken, alsKommentar, textarea);
            ++i;
        }
    }

    public void schreibeXMLDatenAllerUnterElemente(Element parent) {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).schreibeXMLDaten(parent);
            ++i;
        }
    }

    private int gibTextbreite(String s) {
        return this.g != null ? (int)this.g.getFontMetrics().getStringBounds(s, this.g).getBounds().getWidth() : s.length() * 4;
    }

    public void alleZeichnen() {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).zeichne();
            ++i;
        }
    }

    public void graphicsAllerUnterlementeSetzen(Graphics2D g) {
        this.g = g;
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).setzeGraphics(g);
            ++i;
        }
    }

    public boolean istUnterelement(StruktogrammElement eventuellesUnterelement) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == eventuellesUnterelement || ((StruktogrammElement)this.get(i)).istUnterelement(eventuellesUnterelement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void hinzufuegen(StruktogrammElement neues) {
        this.hinzufuegen(neues, null, true);
    }

    public void hinzufuegen(StruktogrammElement neues, StruktogrammElement naechstesOderVorheriges, boolean vorDemAltenEinfuegen) {
        ArrayList<StruktogrammElement> list = new ArrayList<StruktogrammElement>();
        list.add(neues);
        this.hinzufuegen(list, naechstesOderVorheriges, vorDemAltenEinfuegen);
    }

    public void hinzufuegen(ArrayList<StruktogrammElement> neue, StruktogrammElement naechstesOderVorheriges, boolean vorDemAltenEinfuegen) {
        Object leeres = null;
        if (!this.isEmpty() && this.get(0) instanceof LeerElement) {
            leeres = this.get(0);
        }
        if (naechstesOderVorheriges != null) {
            int position = this.indexOf(naechstesOderVorheriges);
            if (!vorDemAltenEinfuegen) {
                ++position;
            }
            for (StruktogrammElement strElem : neue) {
                this.add(position, strElem);
                ++position;
            }
        } else {
            for (StruktogrammElement strElem : neue) {
                this.add(strElem);
            }
        }
        if (leeres != null) {
            this.remove(this.indexOf(leeres));
        }
    }

    public void entfernen(StruktogrammElement zuLoeschen) {
        this.remove(this.indexOf(zuLoeschen));
        if (this.size() == 0) {
            this.add(new LeerElement(this.g));
        }
    }

    public void alleEntfernen() {
        this.clear();
        this.add(new LeerElement(this.g));
    }

    public Object gibElementAnPos(int x, int y, boolean nurListe) {
        if (this.bereich.contains(x, y)) {
            int i = 0;
            while (i < this.size()) {
                Object tmp = ((StruktogrammElement)this.get(i)).gibElementAnPos(x, y, nurListe);
                if (tmp != null) {
                    return tmp;
                }
                ++i;
            }
            if (nurListe) {
                return this;
            }
        }
        return null;
    }

    public StruktogrammElementListe gibListeDieDasElementHat(StruktogrammElement element) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(i) == element) {
                return this;
            }
            StruktogrammElementListe tmp = ((StruktogrammElement)this.get(i)).gibListeDieDasElementHat(element);
            if (tmp != null) {
                return tmp;
            }
            ++i;
        }
        return null;
    }

    public Dimension gibDimensionDerUnterelemente() {
        int breite = 0;
        int hoehe = 0;
        int i = 0;
        while (i < this.size()) {
            Rectangle rect = ((StruktogrammElement)this.get(i)).gibRectangle();
            if (rect.width > breite) {
                breite = rect.width;
            }
            hoehe += rect.height;
            ++i;
        }
        return new Dimension(breite, hoehe);
    }

    public void xPosAllerUnterelementeSetzen(int x) {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).setzeXPos(x);
            ++i;
        }
        this.bereich.x = x;
    }

    public void breiteDerUnterelementeSetzen(int neueBreite) {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).setzeBreite(neueBreite);
            ++i;
        }
        this.bereich.width = neueBreite;
    }

    public void gesamtHoeheSetzen(int neueHoehe) {
        if (this.size() > 0) {
            int hoeheVorher = ((StruktogrammElement)this.get(this.size() - 1)).gibHoehe();
            ((StruktogrammElement)this.get(this.size() - 1)).setzeHoehe(neueHoehe - (this.bereich.height - hoeheVorher));
        }
        this.bereich.height = neueHoehe;
    }

    public Rectangle zeichenbereichAllerElementeAktualisieren(int x, int y) {
        int neueYPos = y;
        int i = 0;
        while (i < this.size()) {
            neueYPos = (int)((double)neueYPos + ((StruktogrammElement)this.get(i)).zeichenbereichAktualisieren(x, neueYPos).getHeight());
            ++i;
        }
        Dimension dim = this.gibDimensionDerUnterelemente();
        if (dim.width < this.gibTextbreite(String.valueOf(this.gibBeschreibung()) + 8)) {
            dim.width = this.gibTextbreite(this.gibBeschreibung()) + 8;
        }
        this.breiteDerUnterelementeSetzen(dim.width);
        this.bereich.setSize(dim);
        this.bereich.setLocation(x, y);
        return this.bereich;
    }

    public int gibBreite() {
        return this.bereich.width;
    }

    public int gibHoehe() {
        return this.bereich.height;
    }

    public int gibRechterRand() {
        return this.bereich.x + this.bereich.width;
    }

    public int gibX() {
        return this.bereich.x;
    }

    public void zoomsAllerElementeZuruecksetzen() {
        int i = 0;
        while (i < this.size()) {
            ((StruktogrammElement)this.get(i)).zoomsZuruecksetzen();
            ++i;
        }
    }
}

