/*
 * Decompiled with CFR 0.152.
 */
package struktogrammelemente;

import control.GlobalSettings;
import control.XMLLeser;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.jdom.Element;
import other.JTextAreaEasy;
import struktogrammelemente.StruktogrammElement;
import struktogrammelemente.StruktogrammElementListe;
import struktogrammelemente.Verzweigung;

public class Fallauswahl
extends StruktogrammElement {
    protected int xVerschiebungFuerTrennlinie;
    protected int yVerschiebungFuerTrennLinie;
    protected ArrayList<StruktogrammElementListe> listen;

    public Fallauswahl(Graphics2D g) {
        this(g, 3);
    }

    public Fallauswahl(Graphics2D g, int anzahlListen) {
        super(g);
        this.erstelleNeueListen(anzahlListen);
        this.yVerschiebungFuerTrennLinie = -20;
        this.listen.get(this.listen.size() - 1).setzeBeschreibung("Sonst");
        this.obererRandZusatz = 40;
        this.setzeText(GlobalSettings.gibElementBeschriftung(2));
    }

    @Override
    public void quellcodeGenerieren(int typ, int anzahlEingerueckt, int anzahlEinzuruecken, boolean alsKommentar, JTextAreaEasy textarea) {
        String vorher = "";
        String nachher = "";
        String fall = "";
        String fallEnde = "";
        switch (typ) {
            case 0: {
                vorher = "switch(" + this.co("kommentar") + this.co("text") + this.co("kommentarzu") + "){\n";
                nachher = "}\n";
                break;
            }
            case 1: {
                vorher = "case " + this.co("kommentar") + this.co("text") + this.co("kommentarzu") + " of\n";
                nachher = "end;\n";
            }
        }
        textarea.hinzufuegen(this.wandleZuAusgabe(vorher, typ, anzahlEingerueckt, alsKommentar));
        int i = 0;
        while (i < this.listen.size()) {
            switch (typ) {
                case 0: {
                    fall = i < this.listen.size() - 1 ? "case " + this.co("kommentar") + this.listen.get(i).gibBeschreibung() + this.co("kommentarzu") + ":\n" : "default: " + this.co("zwangkommentar") + this.listen.get(i).gibBeschreibung() + this.co("zwangkommentarzu") + "\n";
                    fallEnde = this.einruecken("break;\n", anzahlEinzuruecken);
                    break;
                }
                case 1: {
                    fall = i < this.listen.size() - 1 ? String.valueOf(this.co("kommentar")) + this.listen.get(i).gibBeschreibung() + this.co("kommentarzu") + ":\n" : "else " + this.co("zwangkommentar") + this.listen.get(i).gibBeschreibung() + this.co("zwangkommentarzu") + "\n";
                    fall = String.valueOf(fall) + this.einruecken("begin", anzahlEingerueckt + anzahlEinzuruecken) + "\n";
                    fallEnde = "end;\n";
                }
            }
            textarea.hinzufuegen(this.wandleZuAusgabe(fall, typ, anzahlEingerueckt + anzahlEinzuruecken, alsKommentar));
            this.listen.get(i).quellcodeAllerUnterelementeGenerieren(typ, anzahlEingerueckt + anzahlEinzuruecken * 2, anzahlEinzuruecken, alsKommentar, textarea);
            textarea.hinzufuegen(this.wandleZuAusgabe(fallEnde, typ, anzahlEingerueckt + anzahlEinzuruecken, alsKommentar));
            ++i;
        }
        textarea.hinzufuegen(this.wandleZuAusgabe(nachher, typ, anzahlEingerueckt, alsKommentar));
    }

    public void erstelleNeueListen(int anzahlListen) {
        this.listen = new ArrayList();
        int i = 0;
        while (i < anzahlListen) {
            this.listen.add(new StruktogrammElementListe(this.g));
            this.listen.get(i).setzeBeschreibung("" + (i + 1));
            ++i;
        }
    }

    public void erstelleNeueSpalte() {
        int listennummer = this.listen.size() - 1;
        this.listen.add(listennummer, new StruktogrammElementListe(this.g));
        this.listen.get(listennummer).setzeBeschreibung("" + (listennummer + 1));
    }

    public void spalteVerschieben(boolean nachLinks, int spaltenIndex) {
        if (nachLinks) {
            if (spaltenIndex > 0) {
                this.listenTauschen(spaltenIndex, spaltenIndex - 1);
            }
        } else if (spaltenIndex <= this.listen.size() - 2) {
            this.listenTauschen(spaltenIndex, spaltenIndex + 1);
        }
    }

    protected void listenTauschen(int index1, int index2) {
        StruktogrammElementListe tmp = this.listen.get(index1);
        this.listen.set(index1, this.listen.get(index2));
        this.listen.set(index2, tmp);
    }

    public void entferneSpalte(int index) {
        if (index >= 0 && index < this.listen.size() && this.listen.size() > 2) {
            this.listen.remove(index);
        }
    }

    @Override
    protected void zusaetzlicheXMLDatenSchreiben(Element aktuelles) {
        int i = 0;
        while (i < this.listen.size()) {
            Element unterelement = new Element("fall").setAttribute("fallname", XMLLeser.encodeS(this.listen.get(i).gibBeschreibung()));
            this.listen.get(i).schreibeXMLDatenAllerUnterElemente(unterelement);
            aktuelles.addContent(unterelement);
            ++i;
        }
    }

    @Override
    public boolean istUnterelement(StruktogrammElement eventuellesUnterelement) {
        int i = 0;
        while (i < this.listen.size()) {
            if (this.listen.get(i).istUnterelement(eventuellesUnterelement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String[] gibFaelle() {
        String[] faelle = new String[this.listen.size()];
        int i = 0;
        while (i < this.listen.size()) {
            faelle[i] = this.listen.get(i).gibBeschreibung();
            ++i;
        }
        return faelle;
    }

    @Override
    public void setzeFaelle(String[] faelle) {
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).setzeBeschreibung(faelle[i]);
            ++i;
        }
    }

    @Override
    public int gibAnzahlListen() {
        return this.listen.size();
    }

    public StruktogrammElementListe gibListe(int index) {
        return this.listen.get(index);
    }

    @Override
    public boolean neuesElementMussOberhalbPlatziertWerden(int y) {
        return y < this.gibY() + this.getObererRand() / 2;
    }

    @Override
    protected void setzeGraphics(Graphics2D g) {
        super.setzeGraphics(g);
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).graphicsAllerUnterlementeSetzen(g);
            ++i;
        }
    }

    @Override
    public void setzeBreite(int neueBreite) {
        int gesamtbreiteDerListen = 0;
        int neueSpaltenbreite = 0;
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).xPosAllerUnterelementeSetzen(this.gibX() + gesamtbreiteDerListen);
            if (i <= this.listen.size() - 2) {
                neueSpaltenbreite = neueBreite * this.listen.get(i).gibBreite() / this.gibBreite();
                this.listen.get(i).breiteDerUnterelementeSetzen(neueSpaltenbreite);
            } else {
                neueSpaltenbreite = neueBreite - gesamtbreiteDerListen;
                this.listen.get(i).breiteDerUnterelementeSetzen(neueSpaltenbreite);
                this.xVerschiebungFuerTrennlinie = neueBreite - neueSpaltenbreite;
            }
            gesamtbreiteDerListen += neueSpaltenbreite;
            ++i;
        }
        this.bereich.width = neueBreite;
    }

    @Override
    public void setzeHoehe(int neueHoehe) {
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).gesamtHoeheSetzen(neueHoehe - this.getObererRand());
            ++i;
        }
        this.bereich.height = neueHoehe;
    }

    @Override
    protected Object gibElementAnPos(int x, int y, boolean nurListe) {
        if (this.bereich.contains(x, y)) {
            int i = 0;
            while (i < this.listen.size()) {
                Object tmp = this.listen.get(i).gibElementAnPos(x, y, nurListe);
                if (this.objGesetzt(tmp)) {
                    return tmp;
                }
                ++i;
            }
            if (!nurListe) {
                return this;
            }
        }
        return null;
    }

    @Override
    public StruktogrammElementListe gibListeDieDasElementHat(StruktogrammElement element) {
        int i = 0;
        while (i < this.listen.size()) {
            StruktogrammElementListe tmp = this.listen.get(i).gibListeDieDasElementHat(element);
            if (tmp != null) {
                return tmp;
            }
            ++i;
        }
        return null;
    }

    private int gibPassendeYKoordFuerLinie(int x) {
        double m = (double)(this.gibY() - (this.gibY() + this.getObererRand() + this.yVerschiebungFuerTrennLinie)) / (double)(this.gibX() - (this.gibX() + this.xVerschiebungFuerTrennlinie));
        double b = (double)this.gibY() - m * (double)this.gibX();
        return (int)(m * (double)x + b);
    }

    @Override
    public void zeichne() {
        this.eigenenBereichZeichnen();
        int i = 0;
        while (i < this.listen.size()) {
            if (!this.listen.get(i).isEmpty()) {
                this.listen.get(i).alleZeichnen();
            }
            ++i;
        }
        this.g.drawLine(this.gibX(), this.gibY(), this.gibX() + this.xVerschiebungFuerTrennlinie, this.gibY() + this.getObererRand() + this.yVerschiebungFuerTrennLinie);
        this.g.drawLine(this.gibX() + this.xVerschiebungFuerTrennlinie, this.gibY() + this.getObererRand() + this.yVerschiebungFuerTrennLinie, this.gibX() + this.gibBreite(), this.gibY());
        int i2 = 0;
        while (i2 < this.listen.size()) {
            StruktogrammElementListe tmp = this.listen.get(i2);
            int x = tmp.gibRechterRand();
            if (i2 != this.listen.size() - 1) {
                this.g.setColor(Color.black);
                this.g.drawLine(x, this.gibY() + this.gibHoehe(), x, this.gibPassendeYKoordFuerLinie(x));
            }
            x = this instanceof Verzweigung ? (i2 == 0 ? this.gibX() + 5 : tmp.gibRechterRand() - 5 - this.gibTextbreite(tmp.gibBeschreibung())) : tmp.gibX() + this.gibXVerschiebungFuerMittig(tmp.gibBeschreibung(), tmp.gibRechterRand() - tmp.gibX());
            this.g.setColor(this.getFarbeSchrift());
            this.g.drawString(tmp.gibBeschreibung(), x, this.gibY() + this.getObererRand() - 5);
            ++i2;
        }
        this.textZeichnen();
    }

    @Override
    public Rectangle zeichenbereichAktualisieren(int x, int y) {
        int gesamtbreiteDerListen = 0;
        int groessteHoeheDerListen = 0;
        int i = 0;
        while (i < this.listen.size()) {
            Rectangle rectListe = this.listen.get(i).zeichenbereichAllerElementeAktualisieren(x + gesamtbreiteDerListen, y + this.getObererRand());
            gesamtbreiteDerListen += rectListe.width;
            if (rectListe.height > groessteHoeheDerListen) {
                groessteHoeheDerListen = rectListe.height;
            }
            ++i;
        }
        this.xVerschiebungFuerTrennlinie = gesamtbreiteDerListen - this.listen.get(this.listen.size() - 1).gibBreite();
        if (gesamtbreiteDerListen < this.gibMindestbreite()) {
            gesamtbreiteDerListen = this.gibMindestbreite();
        }
        if (GlobalSettings.gibLetzteElementeStrecken()) {
            this.setzeHoehe(this.getObererRand() + groessteHoeheDerListen);
        }
        this.bereich.setBounds(x, y, gesamtbreiteDerListen, this.getObererRand() + groessteHoeheDerListen);
        return this.bereich;
    }

    @Override
    public void setzeXPos(int x) {
        this.bereich.x = x;
        int xVerschiebung = 0;
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).xPosAllerUnterelementeSetzen(x + xVerschiebung);
            xVerschiebung += this.listen.get(i).gibBreite();
            ++i;
        }
    }

    @Override
    public void zoomsZuruecksetzen() {
        super.zoomsZuruecksetzen();
        int i = 0;
        while (i < this.listen.size()) {
            this.listen.get(i).zoomsAllerElementeZuruecksetzen();
            ++i;
        }
    }

    @Override
    public int getObererRand() {
        return super.getObererRand() + this.getYVergroesserung();
    }
}

