/*
 * Decompiled with CFR 0.152.
 */
package de.whiledo.updater;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class WhiledoUpdater {
    public static boolean updater(int versionsnummer, String programmBezeichner) {
        String txtDateipfad = "whiledoJUpdaterData.txt";
        String jarDateipfad = "whiledoJUpdater.jar";
        String fehlerDateipfad = "whiledoJUpdaterErrorLog.html";
        String fehlerprotokoll = "";
        String adresse = "http://main.whiledo.de/programmupdate/update.php?prglng=java&programm=";
        String phpSeite = WhiledoUpdater.sendePostRequest("http://main.whiledo.de/programmupdate/update.php?prglng=java&programm=" + programmBezeichner, null);
        if (phpSeite.equals("")) {
            return false;
        }
        String[] updatedaten = phpSeite.split(";");
        int i = 0;
        while (i < updatedaten.length) {
            updatedaten[i] = updatedaten[i].replaceAll("48921Semikolon78zh43kada29UiMRl", ";");
            ++i;
        }
        int neuesteVersion = Integer.parseInt(updatedaten[0]);
        String updatemanagerDownloadpfad = updatedaten[1];
        String programmname = updatedaten[2];
        String nachrichtAnDenBenutzer = updatedaten[3];
        if (neuesteVersion > versionsnummer) {
            if (JOptionPane.showConfirmDialog(null, "Ein Update f\u00fcr das Programm " + programmname + " ist verf\u00fcgbar. Jetzt durchf\u00fchren?", "Update verf\u00fcgbar", 0) == 0) {
                if (!nachrichtAnDenBenutzer.equals("") && !nachrichtAnDenBenutzer.equals(" ")) {
                    WhiledoUpdater.nachrichtAnzeigen(nachrichtAnDenBenutzer, "Meldung");
                }
                if (WhiledoUpdater.dateiHerunterladen(updatemanagerDownloadpfad, "whiledoJUpdater.jar")) {
                    if (WhiledoUpdater.schreibeTxt(new String[]{programmBezeichner, WhiledoUpdater.programmPfad()}, "whiledoJUpdaterData.txt")) {
                        if (WhiledoUpdater.programmAusfuehren("whiledoJUpdater.jar")) {
                            if (fehlerprotokoll.equals("")) {
                                System.exit(0);
                            }
                        } else {
                            fehlerprotokoll = String.valueOf(fehlerprotokoll) + "<p><b>Der Downloadmanager konnte nicht gestartet werden.</b><br>Starten Sie das Programm \"" + WhiledoUpdater.programmOrdner() + "whiledoJUpdater.jar" + "\"</p><hr>";
                        }
                    } else {
                        fehlerprotokoll = String.valueOf(fehlerprotokoll) + "<p><b>Die Hilfstextdatei konnte nicht erstellt werden.</b><br>Speichern Sie den Inhalt des Textfeldes in eine .txt Datei (mit einem einfachen Texteditor, z.B. mit dem Windows Editor) an dieser Stelle: \"" + WhiledoUpdater.programmOrdner() + "whiledoJUpdaterData.txt" + "\"" + "<br><textarea style=\"width:100%;\">" + programmBezeichner + "\n" + WhiledoUpdater.programmPfad() + "</textarea><br>Starten sie das Update jetzt erneut.</p><hr>";
                    }
                } else {
                    fehlerprotokoll = String.valueOf(fehlerprotokoll) + "<p><b>Der Downloadmanager konnte nicht heruntergeladen werden.</b><br>Sollte der Download bei einem weiteren Versuch erneut fehlschlagen, gibt es 2 M&ouml;glichkeiten:<br><br>1. Eventuell hat das Programm in seinem Ordner keine Schreibrechte.<br>Verschieben Sie f\u00fcr die Zeit des Updates den Ordner \"" + WhiledoUpdater.programmOrdner() + "\" oder zumindest die Datei \"" + WhiledoUpdater.programmPfad() + "\" an einen anderen Ort auf dem Computer," + " an dem das Programm Schreibrechte hat.<br><br><b>Oder:</b><br><br>" + "2. Laden sie den Downloadmanager <a href=\"" + updatemanagerDownloadpfad + "\" target=_blank>hier" + "</a> manuell herunter und speichern sie ihn als \"" + "whiledoJUpdater.jar" + "\" ihm Ordner von " + programmname + " (\"" + WhiledoUpdater.programmOrdner() + "whiledoJUpdater.jar" + "\")" + "<br>Starten Sie das Update neu (\"" + WhiledoUpdater.programmPfad() + "\" starten).</p><hr>";
                }
            }
        } else {
            File datei = new File("whiledoJUpdater.jar");
            if (datei.exists()) {
                datei.delete();
            }
            if ((datei = new File("whiledoJUpdaterData.txt")).exists()) {
                datei.delete();
            }
            if ((datei = new File("whiledoJUpdaterErrorLog.html")).exists()) {
                datei.delete();
            }
        }
        if (!fehlerprotokoll.equals("")) {
            fehlerprotokoll = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html><head><title>Fehler beim Update</title></head><body><h3>Beim Update von " + programmname + " ist ein Fehler aufgetreten. Versuchen Sie das Update erneut. Tritt der Fehler" + " erneut auf, probieren Sie folgende Schritte.</h3><hr>" + fehlerprotokoll + "</body></html>";
            if (WhiledoUpdater.schreibeTxt(fehlerprotokoll, "whiledoJUpdaterErrorLog.html")) {
                WhiledoUpdater.programmAusfuehren("whiledoJUpdaterErrorLog.html");
            } else {
                WhiledoUpdater.nachrichtAnzeigen("Ein Fehler ist aufgetreten und die Fehlerhilfsdatei konnte nicht gespeichert werden.\nW\u00e4hlen Sie einen Ort aus, wo versucht werden soll, die Fehlerhilfsdatei zu speichern.", "Fehler");
                JFileChooser chooser = new JFileChooser();
                String pfad = "";
                if (chooser.showSaveDialog(null) == 0) {
                    pfad = chooser.getSelectedFile().getAbsolutePath();
                    if (new File(pfad = String.valueOf(pfad) + "ErrorFile.html").exists()) {
                        Object[] options = new Object[]{"Ja", "Nein"};
                        if (JOptionPane.showOptionDialog(null, "Die Datei " + pfad + " existiert bereits. \n Wirklich \u00fcberschreiben?", "Datei existiert", 0, 2, null, options, options[1]) != 0) {
                            pfad = "";
                        }
                    }
                }
                if (!pfad.equals("")) {
                    if (WhiledoUpdater.schreibeTxt(fehlerprotokoll, pfad)) {
                        if (!WhiledoUpdater.programmAusfuehren(pfad)) {
                            WhiledoUpdater.nachrichtAnzeigen("Die Fehlerhilfsdatei konnte nicht ge\u00f6ffnet werden.\n\u00d6ffnen Sie die folgende Datei mit ihrem Browser\n\"" + pfad + "\"", "Fehler");
                        }
                    } else {
                        WhiledoUpdater.nachrichtAnzeigen("Die Fehlerhilfsdatei \"" + pfad + "\" kann auch nicht geschrieben werden.\nStarten Sie das Update neu und probieren Sie dann einen anderen Speicherort.", "Fehler");
                    }
                }
            }
            System.exit(0);
        }
        return true;
    }

    public static boolean programmAusfuehren(String pfad) {
        try {
            Desktop.getDesktop().open(new File(pfad));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean homepageAufrufen(String adresse) {
        try {
            Desktop.getDesktop().browse(new URI(adresse));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean dateiHerunterladen(String quelladresse, String zielpfad) {
        return WhiledoUpdater.dateiHerunterladen(quelladresse, zielpfad, null);
    }

    public static boolean dateiHerunterladen(String quelladresse, String zielpfad, JProgressBar progressbar) {
        try {
            int n;
            int bytesGeschrieben = 0;
            URLConnection urlcon = new URL(quelladresse).openConnection();
            boolean benutzeProgressbar = false;
            if (progressbar != null) {
                benutzeProgressbar = true;
                progressbar.setMinimum(0);
                progressbar.setMaximum(urlcon.getContentLength());
                progressbar.setValue(0);
            }
            InputStream in = urlcon.getInputStream();
            FileOutputStream out = new FileOutputStream(zielpfad);
            byte[] buffer = new byte[1024];
            while ((n = in.read(buffer)) != -1) {
                if (benutzeProgressbar) {
                    progressbar.setValue(bytesGeschrieben += n);
                }
                ((OutputStream)out).write(buffer, 0, n);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String sendePostRequest(String adresse, String[] postdaten) {
        String result = "";
        try {
            String line;
            String data = "";
            if (postdaten != null) {
                int i = 0;
                while (i < postdaten.length) {
                    data = String.valueOf(data) + URLEncoder.encode(postdaten[i], "UTF-8");
                    if (i < postdaten.length - 1) {
                        data = String.valueOf(data) + "&";
                    }
                    ++i;
                }
            }
            URL url = new URL(adresse);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            return "";
        }
        return result;
    }

    public static boolean schreibeTxt(String text, String pfad) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(pfad)));
            writer.write(text);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean schreibeTxt(String[] text, String pfad) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(pfad)));
            int i = 0;
            while (i < text.length) {
                writer.write(text[i]);
                if (i < text.length - 1) {
                    writer.write("\r\n");
                }
                ++i;
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String[] leseTxt(String pfad) {
        String tmp = "";
        ArrayList<String> stringlist = new ArrayList<String>();
        try {
            BufferedReader buff = new BufferedReader(new FileReader(pfad));
            while ((tmp = buff.readLine()) != null) {
                stringlist.add(tmp);
            }
            buff.close();
        }
        catch (IOException e) {
            return null;
        }
        String[] result = new String[stringlist.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)stringlist.get(i);
            ++i;
        }
        return result;
    }

    public static String stringArrayZuString(String[] stringArray, String zeilenTrenner) {
        String ausgabe = "";
        int i = 0;
        while (i < stringArray.length) {
            ausgabe = String.valueOf(ausgabe) + stringArray[i];
            if (i < stringArray.length - 1) {
                ausgabe = String.valueOf(ausgabe) + zeilenTrenner;
            }
            ++i;
        }
        return ausgabe;
    }

    public static void nachrichtAnzeigen(String nachricht, String ueberschrift) {
        JOptionPane.showMessageDialog(null, nachricht, ueberschrift, 1);
    }

    public static void nachrichtAnzeigen(String nachricht) {
        WhiledoUpdater.nachrichtAnzeigen(nachricht, "Meldung");
    }

    public static String programmPfad() {
        return System.getProperty("java.class.path");
    }

    public static String pfadExtrahieren(String pfad) {
        return pfad.substring(0, pfad.lastIndexOf(File.separatorChar) + 1);
    }

    public static String programmOrdner() {
        return WhiledoUpdater.pfadExtrahieren(WhiledoUpdater.programmPfad());
    }

    public static ImageIcon ladeImageIconAusResource(String pfadInDerJar, Object diesesObjekt) {
        URL imgURL = diesesObjekt.getClass().getResource(pfadInDerJar);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static void programmBeenden() {
        System.exit(0);
    }
}

