/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.GlobalSettings;
import control.XMLLeser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import struktogrammelemente.Anweisung;
import struktogrammelemente.Aufruf;
import struktogrammelemente.Aussprung;
import struktogrammelemente.DoUntilSchleife;
import struktogrammelemente.Endlosschleife;
import struktogrammelemente.Fallauswahl;
import struktogrammelemente.ForSchleife;
import struktogrammelemente.LeerElement;
import struktogrammelemente.Schleife;
import struktogrammelemente.StruktogrammElement;
import struktogrammelemente.StruktogrammElementListe;
import struktogrammelemente.Verzweigung;
import struktogrammelemente.WhileSchleife;
import view.EingabeDialog;
import view.StrFileFilter;
import view.StrTabbedPane;
import view.StruktogrammPopup;

public class Struktogramm
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
DropTargetListener,
DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = 8269048981647964473L;
    private StruktogrammElementListe liste;
    private Graphics2D g;
    private StruktogrammElement markiertesElement;
    private BufferedImage bild;
    private int sperre = 0;
    private static final int sperreAktualisierung = 0;
    private boolean popupmenuSichtbar = false;
    private StrTabbedPane tabbedpane;
    private Dimension dimGroesse;
    private static final int randLinks = 20;
    private static final int randOben = 20;
    private DragSource dragSource;
    private StruktogrammPopup popup;
    private StruktogrammElement dragZwischenlagerElement;
    private StruktogrammElementListe dragZwischenlagerListe;
    private Rectangle rectVorschau;
    private String aktuellerSpeicherpfad;
    private ArrayList<Document> rueckgaengigListe;
    private int posInRueckgaengigListe = 0;
    private int posInRueckgaengigListeWoZuletztGespeichert = -1;
    private Font fontStr = GlobalSettings.fontStandard;
    private Point[] pointMarkierungEckPunkte = null;
    public static final int typAnweisung = 0;
    public static final int typVerzweigung = 1;
    public static final int typFallauswahl = 2;
    public static final int typForSchleife = 3;
    public static final int typWhileSchleife = 4;
    public static final int typDoUntilSchleife = 5;
    public static final int typEndlosschleife = 6;
    public static final int typAussprung = 7;
    public static final int typAufruf = 8;
    public static final int typLeerElement = 9;
    private String struktogrammBeschreibung = "";

    public void setStruktogrammBeschreibung(String s) {
        this.struktogrammBeschreibung = s;
    }

    public String getStruktogrammBeschreibung() {
        return this.struktogrammBeschreibung;
    }

    public Struktogramm(StrTabbedPane tabbedpane) {
        super(true);
        this.setBackground(Color.white);
        this.tabbedpane = tabbedpane;
        this.setBounds(0, 0, 0, 0);
        this.dimGroesse = this.getSize();
        this.aktuellerSpeicherpfad = "";
        this.liste = new StruktogrammElementListe(null);
        this.liste.setzeBeschreibung("hauptliste");
        this.rueckgaengigListeInitialisieren();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (GlobalSettings.isBeiMausradGroesseAendern()) {
            this.addMouseWheelListener(this);
        }
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this, true, null);
        this.rueckgaengigPunktSetzen(false);
    }

    public void mausradScrollEinOderAusschalten(boolean einschalten) {
        if (einschalten) {
            this.addMouseWheelListener(this);
        } else {
            this.removeMouseWheelListener(this);
        }
    }

    public StruktogrammElementListe gibListe() {
        return this.liste;
    }

    public Graphics2D gibGraphics() {
        return this.g;
    }

    public StrTabbedPane gibTabbedPane() {
        return this.tabbedpane;
    }

    public void setzePopupmenuSichtbar(boolean neuerStatus) {
        this.popupmenuSichtbar = neuerStatus;
    }

    public static int strElementZuTypnummer(StruktogrammElement str) {
        if (str instanceof Verzweigung) {
            return 1;
        }
        if (str instanceof Fallauswahl) {
            return 2;
        }
        if (str instanceof ForSchleife) {
            return 3;
        }
        if (str instanceof WhileSchleife) {
            return 4;
        }
        if (str instanceof DoUntilSchleife) {
            return 5;
        }
        if (str instanceof Endlosschleife) {
            return 6;
        }
        if (str instanceof Aussprung) {
            return 7;
        }
        if (str instanceof Aufruf) {
            return 8;
        }
        if (str instanceof LeerElement) {
            return 9;
        }
        if (str instanceof Anweisung) {
            return 0;
        }
        return -1;
    }

    public boolean graphicsInitialisieren() {
        if (this.dimGroesse.width > 0 || this.dimGroesse.height > 0) {
            this.bild = (BufferedImage)this.createImage(this.dimGroesse.width, this.dimGroesse.height);
            this.g = this.bild.createGraphics();
            if (GlobalSettings.isKantenglaettungVerwenden()) {
                this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.g.setFont(this.fontStr);
            this.liste.graphicsAllerUnterlementeSetzen(this.g);
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.zeichne(g);
    }

    public void zeichne() {
        this.repaint();
    }

    public void zeichne(Graphics panelGraphics) {
        if (this.g != null) {
            this.g.setColor(Color.white);
            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.g.setColor(Color.black);
            if (!this.struktogrammBeschreibung.isEmpty()) {
                Font f = this.g.getFont();
                this.g.setFont(new Font(f.getFamily(), f.getStyle(), 20));
                this.g.drawString(this.struktogrammBeschreibung, this.getXVerschiebungForCenteredText(this.struktogrammBeschreibung, this.dimGroesse.width, this.g), 35);
                this.g.setFont(f);
                this.g.drawRect(10, 10, this.dimGroesse.width - 21, this.dimGroesse.height - 21);
            }
            this.liste.alleZeichnen();
            if (this.rectVorschau != null) {
                this.g.setColor(Color.red);
                this.g.fillRect(this.rectVorschau.x, this.rectVorschau.y, this.rectVorschau.width, this.rectVorschau.height);
            }
            if (this.dragZwischenlagerElement != null) {
                Rectangle rectDragElement = this.dragZwischenlagerElement.gibRectangle();
                this.g.setColor(Color.blue);
                this.g.drawRect(rectDragElement.x, rectDragElement.y, rectDragElement.width, rectDragElement.height);
                this.g.drawRect(rectDragElement.x + 1, rectDragElement.y + 1, rectDragElement.width - 2, rectDragElement.height - 2);
            }
            panelGraphics.drawImage(this.bild, 0, 0, this.dimGroesse.width, this.dimGroesse.height, this);
        } else if (this.graphicsInitialisieren()) {
            this.zeichenbereichAktualisieren();
            this.zeichne();
        }
        if (this.popupmenuSichtbar && this.popup != null) {
            this.popup.repaint();
        }
    }

    private int getXVerschiebungForCenteredText(String s, int breiteUntergrund, Graphics2D g) {
        int i = g != null ? (int)g.getFontMetrics().getStringBounds(s, g).getBounds().getWidth() : s.length() * 4;
        return (breiteUntergrund - i) / 2;
    }

    public void zeichenbereichAktualisieren() {
        int randLinksNeu = 20 + (!this.struktogrammBeschreibung.isEmpty() ? 20 : 0);
        int randObenNeu = 20 + (!this.struktogrammBeschreibung.isEmpty() ? 40 : 0);
        this.dimGroesse = this.liste.zeichenbereichAllerElementeAktualisieren(randLinksNeu, randObenNeu).getSize();
        this.dimGroesse.width += randLinksNeu * 2;
        this.dimGroesse.height += randObenNeu * 2;
        this.setSize(this.dimGroesse);
        this.setPreferredSize(this.dimGroesse);
        this.graphicsInitialisieren();
    }

    private void rueckgaengigListeInitialisieren() {
        this.rueckgaengigListe = new ArrayList();
    }

    public void rueckgaengigPunktSetzen() {
        this.rueckgaengigPunktSetzen(true);
    }

    public void rueckgaengigPunktSetzen(boolean tabbedpaneTitelAnpassen) {
        int i = this.rueckgaengigListe.size() - 1;
        while (i > this.posInRueckgaengigListe) {
            this.rueckgaengigListe.remove(i);
            if (i == this.posInRueckgaengigListeWoZuletztGespeichert) {
                this.posInRueckgaengigListeWoZuletztGespeichert = -1;
            }
            --i;
        }
        this.rueckgaengigListe.add(this.xmlErstellen());
        this.posInRueckgaengigListe = this.rueckgaengigListe.size() - 1;
        if (tabbedpaneTitelAnpassen) {
            this.tabbedpane.titelDerAktuellenSeiteAlsBearbeitetOderAlsGespespeichertMarkieren(true);
        }
    }

    public void schrittZurueck() {
        if (this.posInRueckgaengigListe > 0) {
            --this.posInRueckgaengigListe;
            this.laden(this.rueckgaengigListe.get(this.posInRueckgaengigListe));
        }
    }

    public void schrittNachVorne() {
        if (this.posInRueckgaengigListe < this.rueckgaengigListe.size() - 1) {
            ++this.posInRueckgaengigListe;
            this.laden(this.rueckgaengigListe.get(this.posInRueckgaengigListe));
        }
    }

    private void elementAnPosBefuellen(int x, int y) {
        this.elementBefuellen((StruktogrammElement)this.liste.gibElementAnPos(x, y, false));
    }

    public void elementBefuellen(StruktogrammElement element) {
        if (element != null && !(element instanceof LeerElement)) {
            String[] text = this.eingabeBox(element);
            if (text != null) {
                element.setzeText(text);
                this.rueckgaengigPunktSetzen();
            }
            this.zeichenbereichAktualisieren();
            this.zeichne();
        }
    }

    public String[] eingabeBox(StruktogrammElement tmp) {
        EingabeDialog dialog = new EingabeDialog(this.tabbedpane.gibGUI(), "Inhalt \u00e4ndern", true, tmp);
        return dialog.gibTextArray();
    }

    private void vorschauMarkierungAnzeigen(int x, int y, boolean vorschauFuerNeuesElement) {
        StruktogrammElement tmp = (StruktogrammElement)this.liste.gibElementAnPos(x, y, false);
        this.entmarkieren();
        if (tmp != null) {
            this.markiertesElement = tmp;
            tmp.setzeMarkiert(true);
            if (vorschauFuerNeuesElement) {
                this.rectVorschau = tmp.gibVorschauRect(new Point(x, y));
            }
        }
    }

    private void entmarkieren() {
        if (this.markiertesElement != null) {
            this.markiertesElement.setzeMarkiert(false);
        }
        this.rectVorschau = null;
    }

    public StruktogrammElement neuesStruktogrammElement(int typ) {
        switch (typ) {
            case 0: {
                return new Anweisung(this.g);
            }
            case 1: {
                return new Verzweigung(this.g);
            }
            case 2: {
                return new Fallauswahl(this.g);
            }
            case 3: {
                return new ForSchleife(this.g);
            }
            case 4: {
                return new WhileSchleife(this.g);
            }
            case 5: {
                return new DoUntilSchleife(this.g);
            }
            case 6: {
                return new Endlosschleife(this.g);
            }
            case 7: {
                return new Aussprung(this.g);
            }
            case 8: {
                return new Aufruf(this.g);
            }
            case 9: {
                return new LeerElement(this.g);
            }
        }
        return null;
    }

    public void neuesElementAnAktuellerStelleEinfuegen(int typ) {
        Point p = this.getMousePosition();
        this.gezogenesElementEinfuegen(p.x, p.y, typ);
    }

    public void elementAnAktuellerStelleLoeschen() {
        Point p = this.getMousePosition();
        StruktogrammElement element = (StruktogrammElement)this.liste.gibElementAnPos(p.x, p.y, false);
        if (element != null) {
            this.elementLoeschen(element, false);
        }
    }

    public void zoomAktuellesElement(boolean groesser) {
        StruktogrammElement element;
        Point p = this.getMousePosition();
        if (p != null && (element = (StruktogrammElement)this.liste.gibElementAnPos(p.x, p.y, false)) != null) {
            this.zoom(groesser ? 1 : -1, groesser ? 1 : -1, element);
        }
    }

    public StruktogrammElement getElementUnterMaus() {
        Point p = this.getMousePosition();
        if (p != null) {
            return (StruktogrammElement)this.liste.gibElementAnPos(p.x, p.y, false);
        }
        return null;
    }

    private void gezogenesElementEinfuegen(int x, int y, int typ) {
        StruktogrammElement neues = this.neuesStruktogrammElement(typ);
        if (neues != null) {
            this.elementEinfuegen(x, y, neues, null);
        }
    }

    private void elementEinfuegen(int x, int y, StruktogrammElement neues, StruktogrammElementListe listeNeue) {
        StruktogrammElementListe listeZumEinfuegen = (StruktogrammElementListe)this.liste.gibElementAnPos(x, y, true);
        if (listeZumEinfuegen != null) {
            StruktogrammElement tmp = (StruktogrammElement)listeZumEinfuegen.gibElementAnPos(x, y, false);
            boolean oberhalbEinfuegen = false;
            if (tmp != null) {
                oberhalbEinfuegen = tmp.neuesElementMussOberhalbPlatziertWerden(y);
            }
            if (neues != null || listeNeue != null) {
                if (neues != null) {
                    listeZumEinfuegen.hinzufuegen(neues, tmp, oberhalbEinfuegen);
                }
                if (listeNeue != null) {
                    listeZumEinfuegen.hinzufuegen(listeNeue, tmp, oberhalbEinfuegen);
                }
                this.rectVorschau = null;
                this.zeichenbereichAktualisieren();
                this.zeichne();
                this.rueckgaengigPunktSetzen();
            }
        }
    }

    public StruktogrammElement gibZwischenlagerElement() {
        return this.dragZwischenlagerElement;
    }

    private void elementAusKopierFeldEinfuegen(int x, int y) {
        XMLLeser xmlLeser = new XMLLeser();
        StruktogrammElementListe neue = xmlLeser.erstelleStruktogrammElementListe(this.tabbedpane.gibGUI().gibAuswahlPanel().gibKopiertesStrElement(), this);
        if (neue != null) {
            this.elementEinfuegen(x, y, null, neue);
        }
    }

    public void elementAusKopierFeldEinfuegenAnMausPos() {
        Point p = this.getMousePosition();
        if (p != null) {
            this.elementAusKopierFeldEinfuegen(p.x, p.y);
        }
    }

    private void elementAusZwischenlagerEinfuegen(int x, int y) {
        StruktogrammElement tmp = (StruktogrammElement)this.liste.gibElementAnPos(x, y, false);
        if (tmp != null && tmp != this.dragZwischenlagerElement && !this.dragZwischenlagerElement.istUnterelement(tmp)) {
            this.elementAusZwischenlagerGanzEntfernen();
            this.elementEinfuegen(x, y, this.dragZwischenlagerElement, null);
        }
    }

    public void elementAusZwischenlagerGanzEntfernen() {
        this.dragZwischenlagerListe.entfernen(this.dragZwischenlagerElement);
    }

    public void elementLoeschen(StruktogrammElement zuLoeschen, boolean vorherFragen) {
        String frage = zuLoeschen instanceof Schleife || zuLoeschen instanceof Fallauswahl ? "Dieses Element und dessen Unterelemente entfernen?" : "Dieses Element entfernen?";
        if (!vorherFragen || JOptionPane.showConfirmDialog(null, frage, "L\u00f6schen", 0) == 0) {
            StruktogrammElementListe tmp = this.liste.gibListeDieDasElementHat(zuLoeschen);
            if (tmp != null) {
                tmp.entfernen(zuLoeschen);
            }
            this.zeichenbereichAktualisieren();
            this.zeichne();
            this.rueckgaengigPunktSetzen();
        }
    }

    private void popupMenueZeigen(int x, int y) {
        StruktogrammElement tmp = (StruktogrammElement)this.liste.gibElementAnPos(x, y, false);
        if (tmp != null && !(tmp instanceof LeerElement)) {
            this.popup = new StruktogrammPopup(tmp, this);
            this.popup.show(this, x, y);
        }
    }

    public String gibAktuellenSpeicherpfad() {
        return this.aktuellerSpeicherpfad;
    }

    private void setzeAktuellerSpeicherpfad(String pfad) {
        this.aktuellerSpeicherpfad = pfad;
        this.tabbedpane.titelDerAktuellenSeiteSetzen(this.aktuellerSpeicherpfad.substring(pfad.lastIndexOf(File.separatorChar) + 1));
    }

    private String extrahiereExtension(String pfad) {
        return pfad.substring(pfad.lastIndexOf(".") + 1);
    }

    public BufferedImage generateImage(boolean mitRand) {
        this.entmarkieren();
        this.zeichne();
        return this.bild.getSubimage(mitRand ? 0 : 20, mitRand ? 0 : 20, this.liste.gibBreite() + (mitRand ? 40 : 1), this.liste.gibHoehe() + (mitRand ? 40 : 1));
    }

    public String alsBilddateiSpeichern(String voreingestellterPfad) {
        String pfad = this.saveFileChooser(new int[]{4, 5, 6, 7, 3}, voreingestellterPfad);
        if (!pfad.equals("")) {
            BufferedImage ausgabeBild = this.generateImage(false);
            try {
                BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(new File(pfad)));
                ImageIO.write((RenderedImage)ausgabeBild, this.extrahiereExtension(pfad), oStream);
                oStream.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pfad;
    }

    public String speichern(boolean neunenSpeicherpfadAuswaehlenLassen, String voreingestellterPfad) {
        if (neunenSpeicherpfadAuswaehlenLassen || this.aktuellerSpeicherpfad.equals("")) {
            this.xmlSpeichern(voreingestellterPfad);
        } else {
            this.xmlAbspeichernOhneFileChooser(this.aktuellerSpeicherpfad);
        }
        return this.aktuellerSpeicherpfad;
    }

    public void laden(String pfad) {
        XMLLeser tmp = new XMLLeser();
        tmp.ladeXLM(pfad, this);
        this.setzeAktuellerSpeicherpfad(pfad);
        this.rueckgaengigListeInitialisieren();
        this.rueckgaengigPunktSetzen(false);
        this.posInRueckgaengigListeWoZuletztGespeichert = 0;
        this.zeichenbereichAktualisieren();
        this.zeichne();
    }

    private void laden(Document document) {
        XMLLeser tmp = new XMLLeser();
        tmp.ladeXLM(document, this);
        this.tabbedpane.titelDerAktuellenSeiteAlsBearbeitetOderAlsGespespeichertMarkieren(this.posInRueckgaengigListeWoZuletztGespeichert != this.posInRueckgaengigListe);
        this.zeichenbereichAktualisieren();
        this.zeichne();
    }

    public static String oeffnenDialog(String voreingestellterOrdnerpfad, Component parentComponent) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new StrFileFilter(0));
        if (!voreingestellterOrdnerpfad.equals("")) {
            chooser.setCurrentDirectory(new File(voreingestellterOrdnerpfad));
        }
        int returnVal = chooser.showOpenDialog(parentComponent);
        String pfad = "";
        if (returnVal == 0) {
            pfad = chooser.getSelectedFile().getAbsolutePath();
        }
        return pfad;
    }

    public Document xmlErstellen() {
        Element element = new Element("struktogramm");
        element.setAttribute("fontfamily", XMLLeser.encodeS(this.fontStr.getFamily())).setAttribute("fontstyle", "" + this.fontStr.getStyle()).setAttribute("fontsize", "" + this.fontStr.getSize()).setAttribute("caption", XMLLeser.encodeS(this.struktogrammBeschreibung));
        Document myDocument = new Document(element);
        this.liste.schreibeXMLDatenAllerUnterElemente(element);
        return myDocument;
    }

    public Document xmlErstellen(StruktogrammElement wurzelElement) {
        if (!(wurzelElement instanceof LeerElement)) {
            Element element = new Element("struktogrammelement");
            Document myDocument = new Document(element);
            wurzelElement.schreibeXMLDaten(element);
            return myDocument;
        }
        return null;
    }

    private String saveFileChooser(int[] struktogrammFilterNummern, String voreingestellterPfad) {
        JFileChooser chooser = new JFileChooser();
        int i = 0;
        while (i < struktogrammFilterNummern.length) {
            chooser.addChoosableFileFilter(new StrFileFilter(struktogrammFilterNummern[i]));
            ++i;
        }
        if (!voreingestellterPfad.equals("")) {
            chooser.setCurrentDirectory(new File(voreingestellterPfad));
        }
        int returnVal = chooser.showSaveDialog(this.tabbedpane.gibGUI());
        String pfad = "";
        if (returnVal == 0) {
            pfad = chooser.getSelectedFile().getAbsolutePath();
            if (chooser.getFileFilter() instanceof StrFileFilter) {
                pfad = ((StrFileFilter)chooser.getFileFilter()).erweiterungBeiBedarfAnhaengen(pfad);
            }
            if (new File(pfad).exists()) {
                Object[] options = new Object[]{"Ja", "Nein"};
                if (JOptionPane.showOptionDialog(null, "Die Datei " + pfad + " existiert bereits. \n Wirklich \u00fcberschreiben?", "Datei existiert", 0, 2, null, options, options[1]) != 0) {
                    pfad = "";
                }
            }
        }
        return pfad;
    }

    private void xmlSpeichern(String voreingestellterPfad) {
        String pfad = !this.aktuellerSpeicherpfad.equals("") ? this.aktuellerSpeicherpfad : voreingestellterPfad;
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        if (!(pfad = this.saveFileChooser(nArray, pfad)).equals("")) {
            this.setzeAktuellerSpeicherpfad(pfad);
            this.xmlAbspeichernOhneFileChooser(pfad);
        }
    }

    private void xmlAbspeichernOhneFileChooser(String pfad) {
        Document myDocument = this.xmlErstellen();
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            FileWriter writer = new FileWriter(pfad);
            outputter.output(myDocument, (Writer)writer);
            writer.close();
            this.tabbedpane.titelDerAktuellenSeiteAlsBearbeitetOderAlsGespespeichertMarkieren(false);
            this.posInRueckgaengigListeWoZuletztGespeichert = this.posInRueckgaengigListe;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mausBewegt(int x, int y, boolean vorschauFuerNeuesElement) {
        if (this.sperre == 0) {
            this.vorschauMarkierungAnzeigen(x, y, vorschauFuerNeuesElement);
            this.zeichne();
            this.sperre = 0;
        } else {
            --this.sperre;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mausBewegt(e.getX(), e.getY(), false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        if (this.pointMarkierungEckPunkte != null || this.liste.gibElementAnPos(p.x, p.y, false) == null) {
            if (this.pointMarkierungEckPunkte == null) {
                this.pointMarkierungEckPunkte = new Point[2];
                this.pointMarkierungEckPunkte[0] = this.pointMarkierungEckPunkte[1] = p;
            } else {
                this.pointMarkierungEckPunkte[1] = p;
            }
        }
        this.mausBewegt(e.getX(), e.getY(), false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        switch (e.getModifiers()) {
            case 16: {
                this.elementAnPosBefuellen(e.getX(), e.getY());
                this.pointMarkierungEckPunkte = null;
                this.zeichne();
                break;
            }
            case 4: {
                this.popupMenueZeigen(e.getX(), e.getY());
            }
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        Point mausPos = this.bildschirmKoordZuStruktogrammKoord(evt.getDragOrigin());
        this.dragZwischenlagerListe = (StruktogrammElementListe)this.liste.gibElementAnPos(mausPos.x, mausPos.y, true);
        if (this.dragZwischenlagerListe != null) {
            this.dragZwischenlagerElement = (StruktogrammElement)this.dragZwischenlagerListe.gibElementAnPos(mausPos.x, mausPos.y, false);
            if (this.dragZwischenlagerElement != null && !(this.dragZwischenlagerElement instanceof LeerElement)) {
                StringSelection t = new StringSelection("z");
                this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
            } else {
                this.dragZwischenlagerElement = null;
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
        this.dragZwischenlagerElement = null;
        this.zeichne();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            event.acceptDrop(event.getSourceActions());
            Transferable tr = event.getTransferable();
            String dragTyp = (String)tr.getTransferData(tr.getTransferDataFlavors()[0]);
            switch (dragTyp.charAt(0)) {
                case 'n': {
                    int typ = Integer.parseInt("" + dragTyp.charAt(1));
                    Point mausPos = this.bildschirmKoordZuStruktogrammKoord(event.getLocation());
                    this.gezogenesElementEinfuegen(mausPos.x, mausPos.y, typ);
                    break;
                }
                case 'z': {
                    Point mausPos = this.bildschirmKoordZuStruktogrammKoord(event.getLocation());
                    this.elementAusZwischenlagerEinfuegen(mausPos.x, mausPos.y);
                    break;
                }
                case 'k': {
                    Point mausPos = this.bildschirmKoordZuStruktogrammKoord(event.getLocation());
                    this.elementAusKopierFeldEinfuegen(mausPos.x, mausPos.y);
                }
            }
            event.dropComplete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
        this.entmarkieren();
        this.zeichne();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
        Point mausPos = this.bildschirmKoordZuStruktogrammKoord(evt.getLocation());
        this.mausBewegt(mausPos.x, mausPos.y, true);
    }

    public Point bildschirmKoordZuStruktogrammKoord(Point bildschirmKoord) {
        Point scrollpanePoint = this.getParent().getLocation();
        return new Point(bildschirmKoord.x - scrollpanePoint.x, bildschirmKoord.y - scrollpanePoint.y);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        StruktogrammElement tmp = (StruktogrammElement)this.liste.gibElementAnPos(e.getX(), e.getY(), false);
        if (tmp != null) {
            if (e.getWheelRotation() < 0) {
                this.zoom(1, 1, tmp);
            } else {
                this.zoom(-1, -1, tmp);
            }
        }
    }

    public void zoom(int xMinusEinsNullOderEins, int yMinusEinsNullOderEins, StruktogrammElement tmp) {
        tmp.zoomX(GlobalSettings.getXZoomProSchritt() * xMinusEinsNullOderEins);
        tmp.zoomY(GlobalSettings.getYZoomProSchritt() * yMinusEinsNullOderEins);
        this.zeichenbereichAktualisieren();
        this.zeichne();
        this.tabbedpane.titelDerAktuellenSeiteAlsBearbeitetOderAlsGespespeichertMarkieren(true);
    }

    public void zoomsZuruecksetzen() {
        this.rueckgaengigPunktSetzen(true);
        this.liste.zoomsAllerElementeZuruecksetzen();
        this.zeichenbereichAktualisieren();
        this.zeichne();
        this.rueckgaengigPunktSetzen(false);
    }

    public Font getFontStr() {
        return this.fontStr;
    }

    public void setFontStr(Font fontStr) {
        this.fontStr = fontStr;
    }
}

