/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Konstanten;
import de.whiledo.updater.WhiledoUpdater;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import view.EinstellungsDialog;

public class GlobalSettings
implements Konstanten {
    public static final int updateNummer = 8;
    public static final String versionsString = "1.7.2";
    public static final String guiTitel = "Struktogrammeditor (Miniupdate) 1.7.2";
    public static final String[] updateDaten = new String[]{"30.05.2011", "31.05.2011", "05.06.2011", "11.09.2011", "18.01.2012", "17.02.2012", "02.05.2012", "16.08.2012", "13.05.2014", "10.07.2014"};
    public static final String logoName = "/icons/logostr.png";
    private static final String[][] elementAuswahlBeschriftungen = new String[][]{{"Anweisung", "if (Verzweigung)", "switch (Auswahl)", "For Schleife", "While Schleife", "Do-While Schleife", "Endlosschleife", "Aussprung", "Aufruf", "Leeres Element"}, {"Anweisung", "Verzweigung", "Fallauswahl", "Z\u00e4hlergesteuerte Schleife", "Kopfgesteuerte Schleife", "Fu\u00dfgesteuerte Schleife", "Endlosschleife", "Aussprung", "Aufruf", "Leeres Element"}, {"A", "I", "S", "F", "W", "D", "E", "B", "M", "Leeres Element"}};
    private static int beschriftungsStilAktuell = 1;
    private static int lookAndFeelAktuell = 0;
    private static String zuletztGenutzterSpeicherpfad = "";
    private static String zuletztGenutzterPfadFuerBild = "";
    private static boolean letzteElementeStrecken = false;
    private static String[] elementBeschriftungenZumEinfuegenInDasStruktogramm = new String[10];
    public static final Font fontStandard = new Font("serif", 0, 15);
    private static final String einstellungsDateiPfad = "struktogrammeditor.properties";
    private static final String einstellungsDateiPfadBisVersion1Punkt4 = "StruktogrammeditorEinstellungen.txt";
    private static int codeErzeugerEinrueckungGesamt = 3;
    private static int codeErzeugerEinrueckungProStufe = 3;
    private static int codeErzeugerProgrammiersprache = 0;
    private static boolean codeErzeugerAlsKommentar = true;
    private static boolean beiMausradGroesseAendern = false;
    private static boolean elementShortcutsVerwenden = true;
    private static int xZoomProSchritt = 10;
    private static int yZoomProSchritt = 10;
    private static boolean kantenglaettungVerwenden = false;
    public static final int strgOderApfelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static void init() {
        int i = 0;
        while (i < 10) {
            GlobalSettings.elementBeschriftungenZumEinfuegenInDasStruktogramm[i] = EinstellungsDialog.standardWerte[i];
            ++i;
        }
        GlobalSettings.loadSettings();
    }

    public static String[] getCurrentElementBeschriftungsstil() {
        return elementAuswahlBeschriftungen[beschriftungsStilAktuell >= 0 && beschriftungsStilAktuell < elementAuswahlBeschriftungen.length ? beschriftungsStilAktuell : 0];
    }

    private static void loadSettings() {
        File propertiesFile;
        File f = new File(einstellungsDateiPfadBisVersion1Punkt4);
        if (f.exists()) {
            String[] einstellungsdaten = WhiledoUpdater.leseTxt(einstellungsDateiPfadBisVersion1Punkt4);
            if (einstellungsdaten != null) {
                int i = 0;
                while (i < einstellungsdaten.length) {
                    GlobalSettings.elementBeschriftungenZumEinfuegenInDasStruktogramm[i] = einstellungsdaten[i];
                    ++i;
                }
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        if ((propertiesFile = new File(einstellungsDateiPfad)).exists()) {
            Properties pr = new Properties();
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(propertiesFile));
                pr.load(in);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String s = pr.getProperty("stretchlast");
            if (s != null) {
                letzteElementeStrecken = s.equals("1");
            }
            if ((s = pr.getProperty("cespaces")) != null) {
                codeErzeugerEinrueckungGesamt = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("cespacesperstep")) != null) {
                codeErzeugerEinrueckungProStufe = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("celanguage")) != null) {
                codeErzeugerProgrammiersprache = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("cecomments")) != null) {
                codeErzeugerAlsKommentar = s.equals("1");
            }
            if ((s = pr.getProperty("mousewheelresize")) != null) {
                beiMausradGroesseAendern = s.equals("1");
            }
            if ((s = pr.getProperty("useelementshortcuts")) != null) {
                elementShortcutsVerwenden = s.equals("1");
            }
            if ((s = pr.getProperty("pathfiles")) != null) {
                zuletztGenutzterSpeicherpfad = s;
            }
            if ((s = pr.getProperty("pathpictures")) != null) {
                zuletztGenutzterPfadFuerBild = s;
            }
            if ((s = pr.getProperty("zoomx")) != null) {
                xZoomProSchritt = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("zoomy")) != null) {
                yZoomProSchritt = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("captionstyle")) != null) {
                beschriftungsStilAktuell = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("lookandfeel")) != null) {
                lookAndFeelAktuell = Integer.parseInt(s);
            }
            if ((s = pr.getProperty("useantialiasing")) != null) {
                kantenglaettungVerwenden = s.equals("1");
            }
            int i = 0;
            while (i < 10) {
                s = pr.getProperty("caption" + i);
                if (s != null) {
                    GlobalSettings.elementBeschriftungenZumEinfuegenInDasStruktogramm[i] = s;
                }
                ++i;
            }
        }
    }

    public static void saveSettings() {
        Properties properties = new Properties();
        properties.setProperty("stretchlast", letzteElementeStrecken ? "1" : "0");
        properties.setProperty("cespaces", "" + codeErzeugerEinrueckungGesamt);
        properties.setProperty("cespacesperstep", "" + codeErzeugerEinrueckungProStufe);
        properties.setProperty("celanguage", "" + codeErzeugerProgrammiersprache);
        properties.setProperty("cecomments", codeErzeugerAlsKommentar ? "1" : "0");
        properties.setProperty("mousewheelresize", beiMausradGroesseAendern ? "1" : "0");
        properties.setProperty("useelementshortcuts", elementShortcutsVerwenden ? "1" : "0");
        properties.setProperty("pathfiles", zuletztGenutzterSpeicherpfad);
        properties.setProperty("pathpictures", zuletztGenutzterPfadFuerBild);
        properties.setProperty("zoomx", "" + xZoomProSchritt);
        properties.setProperty("zoomy", "" + yZoomProSchritt);
        properties.setProperty("captionstyle", "" + beschriftungsStilAktuell);
        properties.setProperty("lookandfeel", "" + lookAndFeelAktuell);
        properties.setProperty("useantialiasing", kantenglaettungVerwenden ? "1" : "0");
        int i = 0;
        while (i < 10) {
            properties.setProperty("caption" + i, elementBeschriftungenZumEinfuegenInDasStruktogramm[i]);
            ++i;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(einstellungsDateiPfad)));
            properties.store(out, "Struktogrammeditor Properties");
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setzeSpeicherpfad(String pfad) {
        if (!pfad.equals("")) {
            zuletztGenutzterSpeicherpfad = pfad;
        }
    }

    public static void setzeBildSpeicherpfad(String pfad) {
        if (!pfad.equals("")) {
            zuletztGenutzterPfadFuerBild = pfad;
        }
    }

    public static String getZuletztGenutzterSpeicherpfad() {
        return zuletztGenutzterSpeicherpfad;
    }

    public static String getZuletztGenutzterPfadFuerBild() {
        return zuletztGenutzterPfadFuerBild;
    }

    public static void setzeLetzteElementeStrecken(boolean strecken) {
        letzteElementeStrecken = strecken;
    }

    public static boolean gibLetzteElementeStrecken() {
        return letzteElementeStrecken;
    }

    public static String gibElementBeschriftung(int typNummer) {
        return elementBeschriftungenZumEinfuegenInDasStruktogramm[typNummer];
    }

    public static void setzeElementBeschriftungen(String[] neueBeschriftungen) {
        elementBeschriftungenZumEinfuegenInDasStruktogramm = neueBeschriftungen;
    }

    public static void setCodeErzeugerEinrueckungGesamt(int codeErzeugerEinrueckungGesamt) {
        GlobalSettings.codeErzeugerEinrueckungGesamt = codeErzeugerEinrueckungGesamt;
    }

    public static int getCodeErzeugerEinrueckungGesamt() {
        return codeErzeugerEinrueckungGesamt;
    }

    public static void setCodeErzeugerEinrueckungProStufe(int codeErzeugerEinrueckungProStufe) {
        GlobalSettings.codeErzeugerEinrueckungProStufe = codeErzeugerEinrueckungProStufe;
    }

    public static int getCodeErzeugerEinrueckungProStufe() {
        return codeErzeugerEinrueckungProStufe;
    }

    public static int getCodeErzeugerProgrammiersprache() {
        return codeErzeugerProgrammiersprache;
    }

    public static void setCodeErzeugerProgrammiersprache(int codeErzeugerProgrammiersprache) {
        GlobalSettings.codeErzeugerProgrammiersprache = codeErzeugerProgrammiersprache;
    }

    public static boolean isCodeErzeugerAlsKommentar() {
        return codeErzeugerAlsKommentar;
    }

    public static void setCodeErzeugerAlsKommentar(boolean codeErzeugerAlsKommentar) {
        GlobalSettings.codeErzeugerAlsKommentar = codeErzeugerAlsKommentar;
    }

    public static void setBeiMausradGroesseAendern(boolean beiMausradGroesseAendern) {
        GlobalSettings.beiMausradGroesseAendern = beiMausradGroesseAendern;
    }

    public static boolean isBeiMausradGroesseAendern() {
        return beiMausradGroesseAendern;
    }

    public static int getXZoomProSchritt() {
        return xZoomProSchritt;
    }

    public static void setXZoomProSchritt(int xZoomProSchritt) {
        GlobalSettings.xZoomProSchritt = xZoomProSchritt;
    }

    public static int getYZoomProSchritt() {
        return yZoomProSchritt;
    }

    public static void setYZoomProSchritt(int yZoomProSchritt) {
        GlobalSettings.yZoomProSchritt = yZoomProSchritt;
    }

    public static int getBeschriftungsStilAktuell() {
        return beschriftungsStilAktuell;
    }

    public static void setBeschriftungsStilAktuell(int beschriftungsStilAktuell) {
        GlobalSettings.beschriftungsStilAktuell = beschriftungsStilAktuell;
    }

    public static boolean isElementShortcutsVerwenden() {
        return elementShortcutsVerwenden;
    }

    public static void setElementShortcutsVerwenden(boolean elementShortcutsVerwenden) {
        GlobalSettings.elementShortcutsVerwenden = elementShortcutsVerwenden;
    }

    public static boolean isKantenglaettungVerwenden() {
        return kantenglaettungVerwenden;
    }

    public static void setKantenglaettungVerwenden(boolean kantenglaettungVerwenden) {
        GlobalSettings.kantenglaettungVerwenden = kantenglaettungVerwenden;
    }

    public static int getLookAndFeelAktuell() {
        return lookAndFeelAktuell;
    }

    public static void setLookAndFeelAktuell(int lookAndFeelAktuell) {
        GlobalSettings.lookAndFeelAktuell = lookAndFeelAktuell;
    }
}

